/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools.shadowed.ejt.i18n;

import com.install4j.buildtools.shadowed.ejt.CommonApplicationServices;
import com.install4j.buildtools.shadowed.ejt.i18n.SupportedLocale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.Nullable;

public class SupportedLocaleHelper {
    public static void loadAndSet() {
        SupportedLocaleHelper.load().setCurrent(true);
    }

    public static SupportedLocale load() {
        Preferences preferencesNode = SupportedLocaleHelper.getPreferencesNode();
        String code = System.getProperty("ejt.forceLocale", preferencesNode != null ? preferencesNode.get("locale", null) : null);
        return code == null || Boolean.getBoolean("ejt.forceAutoLocale") ? SupportedLocale.AUTO_DETECT : SupportedLocale.getByCode(code);
    }

    public static void save(SupportedLocale supportedLocale) {
        Preferences node = SupportedLocaleHelper.getPreferencesNode();
        if (node != null) {
            node.put("locale", supportedLocale.getCode());
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    private static Preferences getPreferencesNode() {
        CommonApplicationServices applicationServices = CommonApplicationServices.getInstance();
        if (applicationServices != null) {
            return Preferences.userRoot().node(applicationServices.getPreferenceRootPath());
        }
        return null;
    }
}

