/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools;

import com.install4j.buildtools.BaseTaskConfig;
import com.install4j.buildtools.InvalidConfigException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProjectTaskConfig
extends BaseTaskConfig {
    private final File projectFile;
    private final boolean verbose;
    private final boolean quiet;
    private final boolean test;
    private final boolean failOnWarning;
    private final String release;
    private final File destination;
    private final String license;

    public BaseProjectTaskConfig(@Nullable File installDir, @Nullable File autoProvisioningCacheDir, List<String> vmParameters, File projectFile, boolean verbose, boolean quiet, boolean test, boolean failOnWarning, String release, File destination, String license) {
        super(installDir, autoProvisioningCacheDir, vmParameters);
        this.projectFile = projectFile;
        this.verbose = verbose;
        this.quiet = quiet;
        this.test = test;
        this.failOnWarning = failOnWarning;
        this.release = release;
        this.destination = destination;
        this.license = license;
    }

    @Override
    protected final void buildCommandLine(List<String> commandLine2) throws InvalidConfigException {
        super.buildCommandLine(commandLine2);
        if (this.verbose) {
            commandLine2.add("-v");
        }
        if (this.license != null && !this.license.trim().isEmpty()) {
            commandLine2.add("-L");
            commandLine2.add(this.license);
        }
        if (this.quiet) {
            if (this.verbose) {
                throw new InvalidConfigException("Cannot set both verbose and quiet");
            }
            commandLine2.add("-q");
        }
        if (this.test) {
            commandLine2.add("-t");
        }
        if (this.failOnWarning) {
            commandLine2.add("-w");
        }
        if (this.release != null && !this.release.isEmpty()) {
            commandLine2.add("-r");
            commandLine2.add(this.release);
        }
        if (this.destination != null) {
            commandLine2.add("-d");
            commandLine2.add(this.destination.getPath());
        }
        this.addAdditionalOptions(commandLine2);
        if (this.projectFile == null) {
            throw new InvalidConfigException("property \"projectFile\" must be set");
        }
        if (!this.projectFile.exists()) {
            throw new InvalidConfigException("project file " + this.projectFile + " does not exist");
        }
        commandLine2.add(this.projectFile.getPath());
    }

    protected void addAdditionalOptions(List<String> commandLine2) throws InvalidConfigException {
    }

    protected boolean isTest() {
        return this.test;
    }
}

