/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import com.exe4j.runtime.util.ReadIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    private static final int BUFFER_SIZE = 8192;

    private FileUtil() {
    }

    public static boolean copyFile(File sourceFile, File targetFile) throws IOException {
        return FileUtil.copyFile(sourceFile, targetFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File targetFile, boolean append) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(targetFile, append);
            boolean bl = FileUtil.pumpStream(fis, fos) != -1L;
            return bl;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File targetFile, CopyProgressListener copyProgressListener) throws IOException {
        FileInputStream inputStream = new FileInputStream(sourceFile);
        try {
            boolean bl = FileUtil.extractFile(inputStream, targetFile, sourceFile.length(), copyProgressListener, true);
            return bl;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractFile(InputStream in, File targetFile, long length, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(targetFile);
            boolean bl = FileUtil.pumpStream(in, length, fos, copyProgressListener, checkReadIoException) > -1L;
            return bl;
        }
    }

    public static List<String> readLines(InputStream input) throws IOException {
        String line;
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        while ((line = br.readLine()) != null) {
            while (line.endsWith("\r") || line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            lineList.add(line);
        }
        return lineList;
    }

    public static long pumpStream(InputStream is, OutputStream os) throws IOException {
        return FileUtil.pumpStream(is, os, null);
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener) throws IOException {
        return FileUtil.pumpStream(is, os, copyProgressListener, false);
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        return FileUtil.pumpStream(is, -1L, os, copyProgressListener, checkReadIoException);
    }

    public static long pumpStream(InputStream is, long length, OutputStream os, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        return FileUtil.pumpStream(is, length, false, os, copyProgressListener, checkReadIoException);
    }

    public static long pumpStream(InputStream is, long length, boolean padOrTruncate, OutputStream os, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        boolean useBuffers;
        if (padOrTruncate && length < 0L) {
            throw new IllegalStateException();
        }
        boolean bl = useBuffers = length == -1L || length > 819200L;
        if (useBuffers && !(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is, 8192);
        }
        if (useBuffers && !(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os, 8192);
        }
        byte[] buf = new byte[8192];
        long count = 0L;
        int currentCount = FileUtil.read(is, buf, checkReadIoException);
        while (currentCount != -1) {
            if (padOrTruncate && count + (long)currentCount > length) {
                int truncatedCurrentCount = (int)Math.max(0L, length - count);
                os.write(buf, 0, truncatedCurrentCount);
                count += (long)truncatedCurrentCount;
                break;
            }
            os.write(buf, 0, currentCount);
            count += (long)currentCount;
            if (copyProgressListener != null && !copyProgressListener.progressPerformed(currentCount)) {
                return -1L;
            }
            currentCount = FileUtil.read(is, buf, checkReadIoException);
        }
        if (padOrTruncate && count < length) {
            while (count < length) {
                os.write(0);
                ++count;
            }
        }
        os.flush();
        return count;
    }

    private static int read(InputStream is, byte[] buf, boolean checkReadIoException) throws IOException {
        try {
            return is.read(buf);
        }
        catch (RuntimeException e) {
            if (checkReadIoException) {
                throw new ReadIOException(e);
            }
            throw e;
        }
        catch (IOException e) {
            if (checkReadIoException) {
                throw new ReadIOException(e);
            }
            throw e;
        }
    }

    public static void rename(File tempFile, File destFile) throws IOException {
        int tryNum = 0;
        while (!tempFile.renameTo(destFile)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (destFile.exists()) {
                destFile.delete();
            }
            if (tryNum > 20) {
                throw new IOException("could not rename " + tempFile + " to " + destFile);
            }
            ++tryNum;
        }
    }

    public static boolean isContainedInOrEquals(File file, File parent) {
        try {
            while (file != null) {
                if (file.getCanonicalFile().equals(parent.getCanonicalFile())) {
                    return true;
                }
                file = file.getParentFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, String encoding) throws IOException {
        try (BufferedReader reader = null;){
            int character;
            reader = FileUtil.createTextFileReader(file, encoding);
            StringWriter stringWriter = new StringWriter();
            while ((character = ((Reader)reader).read()) != -1) {
                stringWriter.write(character);
            }
            String string = stringWriter.toString();
            return string;
        }
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.pumpStream(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static BufferedReader createTextFileReader(File file, String encoding) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);
        byte[] signature = new byte[2];
        pushbackInputStream.read(signature);
        pushbackInputStream.unread(signature);
        FilterInputStream sourceInputStream = FileUtil.isGzipStream(signature) ? new GZIPInputStream(pushbackInputStream) : pushbackInputStream;
        InputStreamReader inputStreamReader = encoding == null || encoding.isEmpty() ? new InputStreamReader(sourceInputStream) : new InputStreamReader((InputStream)sourceInputStream, encoding);
        return new BufferedReader(inputStreamReader);
    }

    public static boolean isGzipStream(byte[] bytes) {
        int head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00;
        return head == 35615;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static File getCanonicalFile(File file) {
        if (file != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    public static interface CopyProgressListener {
        public boolean progressPerformed(long var1);
    }
}

