/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.mappers;

import com.install4j.api.beaninfo.EnumerationMapEntry;
import com.install4j.api.beaninfo.EnumerationMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class DefaultEnumerationMapper
implements EnumerationMapper {
    private Class enumerationClass;
    private Map<Object, Icon> icons;
    private Set<Object> values;
    private String context;

    public DefaultEnumerationMapper(Class clazz, Map<Object, Icon> map) {
        this(clazz, map, null, "defaultEnumContext");
    }

    public DefaultEnumerationMapper(Class clazz, Map<Object, Icon> map, Set<Object> set, String string) {
        this.enumerationClass = clazz;
        this.icons = map;
        this.values = set;
        this.context = string;
    }

    public Class getEnumerationClass() {
        return this.enumerationClass;
    }

    public EnumerationMapEntry[] getEnumerationMapEntries() {
        ArrayList<EnumerationMapEntry> arrayList = new ArrayList<EnumerationMapEntry>();
        if (this.enumerationClass.isEnum()) {
            for (Object t2 : this.enumerationClass.getEnumConstants()) {
                if (!this.isValueAccepted(t2)) continue;
                arrayList.add(new EnumerationMapEntry(t2.toString(), t2, this.getIcon(t2)));
            }
        } else {
            Field[] fieldArray;
            for (Field field : fieldArray = this.enumerationClass.getFields()) {
                try {
                    Object object;
                    String string = field.getName();
                    if (!string.toUpperCase().equals(string) || (object = field.get(null)) == null || object.getClass() != this.enumerationClass || !this.isValueAccepted(object)) continue;
                    arrayList.add(new EnumerationMapEntry(object.toString(), object, this.getIcon(object)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return arrayList.toArray(new EnumerationMapEntry[0]);
    }

    private Icon getIcon(Object object) {
        return this.icons != null ? this.icons.get(object) : null;
    }

    private boolean isValueAccepted(Object object) {
        return this.values == null || this.values.contains(object);
    }

    public String getContext() {
        return this.context;
    }
}

