/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.install4j.api.actions.Action;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.jdbc.AbstractJdbcActionBeanInfo;
import com.install4j.runtime.beans.actions.jdbc.SqlQueryAction;
import java.util.List;

@BeanInfo
public class SqlQueryActionBeanInfo
extends AbstractJdbcActionBeanInfo {
    private static final String PROPERTY_SQL_QUERY = "sqlQuery";
    private static final String PROPERTY_FIRST_ONLY = "firstOnly";
    private static final String PROPERTY_FAIL_IF_NOT_FOUND = "failIfNotFound";
    private static final String PROPERTY_VARIABLE_NAME = "variableName";
    private static final String DISPLAY_NAME_SQL_QUERY = "SQL query";
    private static final String DISPLAY_NAME_TAKE_FIRST_ROW_ONLY = "Take first row only";

    public SqlQueryActionBeanInfo() {
        super("Execute SQL query", "Execute a single SQL query and store the result in an installer variable. If only the first row is taken, the row value is stored directly. Otherwise, the variable will contain an instance of <tt>java.util.List</tt> with the row values. If the query is for a single column, the row value is the Java object representation of the return type, e.g. <tt>java.lang.String</tt> for <tt>VARCHAR</tt> or <tt>java.lang.Long</tt> for <tt>INT</tt>.", SqlQueryAction.class);
        this.addPropertyDescriptor(this.categoryQuery(Install4JPropertyDescriptor.create((String)PROPERTY_SQL_QUERY, (Class)this.getBeanClass(), (String)DISPLAY_NAME_SQL_QUERY, (String)"The SQL query. For example, <tt>select count(*) from customers</tt> will return a single row with a single column. To get the integer result directly in the installer variable, you also have to select the \"Take first row only\" property, otherwise a <tt>List&lt;Object&gt;</tt> with one element will be stored in the variable.<p>For queries that return multiple rows like <tt>select first_name, last_name from customer</tt>, each row is stored as an instance of <tt>List&lt;Object&gt;</tt>. If \"Take first row only\" is selected, the variable will contain that list, otherwise it will contain an instance of <tt>List&lt;List&lt;Object&gt;&gt;</tt> with the entire table of the result set.</p>", (String)"multiline")));
        this.addPropertyDescriptor(this.categoryQuery(Install4JPropertyDescriptor.create((String)PROPERTY_FIRST_ONLY, (Class)this.getBeanClass(), (String)DISPLAY_NAME_TAKE_FIRST_ROW_ONLY, (String)"If selected, the result will at most consist of a single row. If the result has only one column, the cell value will be stored directly in the installer variable, otherwise a <tt>List&lt;Object&gt;</tt> with all column values will be stored. Also, if no row is returned, the installer variable will be set to <tt>null</tt>.<p>If not selected, the result will be a  <tt>List&lt;Object&gt;</tt> for a single column and a <tt>List&lt;List&lt;Object&gt;&gt;</tt> for multiple columns.</p>")));
        this.addPropertyDescriptor(this.categoryQuery(Install4JPropertyDescriptor.create((String)PROPERTY_FAIL_IF_NOT_FOUND, (Class)this.getBeanClass(), (String)"Fail if zero rows returned", (String)"If selected, and zero rows are returned, the action will fail, and the installer variable will not be changed.")));
        this.addPropertyDescriptor(this.categoryQuery(Install4JPropertyDescriptor.create((String)PROPERTY_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name for result", (String)"The name of the variable that will be set with the result of the query as explained in the descriptions of the \"SQL query\" and the \"Take first row only\" properties. Enter the variable without the installer prefix and the dollar sign, or leave empty if the error message should not be saved.", (String)PROPERTY_VARIABLE_NAME)));
        this.addErrorMessagesVariableNameProperty();
    }

    private Install4JPropertyDescriptor categoryQuery(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("SQL execution");
        return install4JPropertyDescriptor;
    }

    @Override
    protected Install4JPropertyDescriptor categoryMain(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        return this.categoryQuery(install4JPropertyDescriptor);
    }

    @Override
    public void validateAction(Action action, List<String> list) throws BeanValidationException {
        super.validateAction(action, list);
        this.checkNotEmpty(PROPERTY_SQL_QUERY, (Bean)action);
        this.checkNotEmpty(PROPERTY_VARIABLE_NAME, (Bean)action);
    }
}

