/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.actions.Action;
import com.install4j.api.beaninfo.ActionListInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.ActionUtil;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileActionBeanInfo;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.beans.actions.files.CreateZipFileAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import java.util.List;

@BeanInfo
public class CreateZipFileActionBeanInfo
extends AbstractRecursiveFileActionBeanInfo
implements ActionListInitializer {
    private static final String PROPERTY_ZIP_FILE = "zipFile";
    private static final String PROPERTY_ADD_TOP_LEVEL_DIRECTORIES_TO_RELATIVE_PATH = "addTopLevelDirectoriesToRelativePath";
    private static final String PROPERTY_ZIP_ROOT = "zipRoot";
    private static final String PROPERTY_METHOD = "method";

    public CreateZipFileActionBeanInfo() {
        super("Create a ZIP file", "Create a ZIP file from the specified source files and directories.", (Class<? extends AbstractRecursiveFileAction>)CreateZipFileAction.class, "ZIP files and archives");
        this.addPropertyDescriptor(FilePropertyDescriptor.create((String)PROPERTY_ZIP_FILE, (Class)this.getBeanClass(), (String)"ZIP file", (String)"The ZIP file that should be created.", (FileSelectionMode)FileSelectionMode.FILES_AND_DIRECTORIES).setSortKey(Integer.valueOf(-10)));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ZIP_FILE, Install4JPropertyDescriptor.create((String)PROPERTY_ZIP_ROOT, (Class)this.getBeanClass(), (String)"Resolve relative file in", (String)"A relative zip file can be resolved against the installation directory or against the root of the temporarily extracted archive.").setActionListShownKeys(new String[]{"archive"})));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_ADD_TOP_LEVEL_DIRECTORIES_TO_RELATIVE_PATH, (Class)this.getBeanClass(), (String)"Add top level directories", (String)"If selected, all directories that you have added to the source files will be added under the name of the directory. Otherwise, the contents of the directories will be added directly to the root of ZIP file."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_METHOD, (Class)this.getBeanClass(), (String)"ZIP method", (String)("The compression method used to add files." + ActionUtil.COMPRESSION_METHOD_NOTICE)));
    }

    @Override
    protected String getFilesDisplayName() {
        return "Source files or directories";
    }

    @Override
    protected boolean isRecursiveSupported() {
        return false;
    }

    @Override
    protected boolean isProgressSupported() {
        return true;
    }

    @Override
    protected String getFilesOperationClause() {
        return "to be zipped";
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.checkNotEmpty(PROPERTY_ZIP_FILE, bean);
    }

    public void initializeAction(Action action, List<String> list) {
        ((CreateZipFileAction)action).setZipRoot(ArchiveFileOperationRoot.ARCHIVE);
    }
}

