/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools.shadowed.ejt.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public class CommonPlatformUtil {
    private static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isLinuxX64() {
        return CommonPlatformUtil.isLinux() && CommonPlatformUtil.isX64();
    }

    public static boolean isX64() {
        return OS_ARCH.equals("amd64") || OS_ARCH.equals("x86_64");
    }

    public static String getCurrentXmxValue(String unknownText) {
        long memoryBytes;
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        if (arguments != null) {
            String argumentValue = null;
            for (String argument : arguments) {
                if (!argument.startsWith("-Xmx")) continue;
                argumentValue = argument.substring(4);
            }
            if (argumentValue != null) {
                return argumentValue;
            }
        }
        if ((memoryBytes = Runtime.getRuntime().maxMemory()) == Long.MAX_VALUE || memoryBytes == 0L) {
            return unknownText;
        }
        return (double)memoryBytes * 1.2 / 1024.0 / 1024.0 + "m";
    }
}

