/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools.shadowed.ejt.gui;

import com.install4j.buildtools.shadowed.ejt.util.CommonPlatformUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardUtil {
    public static final String SECONDARY_ACCELERATOR_KEY = "secondaryAcceleratorKey";

    private KeyboardUtil() {
    }

    public static void addAccelerator(int condition, @NotNull JComponent component, Action action) {
        Object key = new Object();
        InputMap inputMap = component.getInputMap(condition);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), key);
        KeyStroke keyStroke = (KeyStroke)action.getValue(SECONDARY_ACCELERATOR_KEY);
        if (keyStroke != null) {
            inputMap.put(keyStroke, key);
        }
        component.getActionMap().put(key, action);
    }

    public static Object addAccelerator(int condition, @NotNull JComponent component, @NotNull JComponent parent, ActionListener listener, int keyCode, int keyMask) {
        return KeyboardUtil.addAccelerator(condition, component, parent, listener, null, keyCode, keyMask);
    }

    public static void addAccelerator(int condition, @NotNull JComponent component, @NotNull JComponent parent, ActionListener listener, KeyStroke keystroke) {
        KeyboardUtil.addAccelerator(condition, component, parent, listener, keystroke.getKeyCode(), keystroke.getModifiers());
    }

    public static Object addAccelerator(int condition, @NotNull JComponent component, @NotNull JComponent parent, ActionListener listener, String actionCommand, int keyCode, int keyMask) {
        ComponentAction action = new ComponentAction(component, listener, actionCommand);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, keyMask);
        Object key = new Object();
        parent.getInputMap(condition).put(keyStroke, key);
        parent.getActionMap().put(key, action);
        return key;
    }

    public static void addAccelerator(int condition, Object key, @NotNull JComponent parent, int keyCode, int keyMask) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, keyMask);
        parent.getInputMap(condition).put(keyStroke, key);
    }

    public static String getAcceleratorTextForTooltip(@Nullable KeyStroke accelerator) {
        if (accelerator == null) {
            return "";
        }
        return " [" + KeyboardUtil.getAcceleratorText(accelerator) + "]";
    }

    public static String getAcceleratorText(@NotNull KeyStroke accelerator) {
        StringBuilder buffer = new StringBuilder();
        KeyboardUtil.appendModifierText(buffer, accelerator.getModifiers());
        int keyCode = accelerator.getKeyCode();
        if (keyCode != 0) {
            buffer.append(KeyEvent.getKeyText(keyCode));
        } else if (accelerator.getKeyChar() == ' ') {
            buffer.append(KeyEvent.getKeyText(32));
        } else {
            buffer.append(accelerator.getKeyChar());
        }
        return buffer.toString();
    }

    public static void appendModifierText(StringBuilder buffer, int modifiers) {
        String acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (acceleratorDelimiter == null) {
            acceleratorDelimiter = "+";
        } else if (acceleratorDelimiter.isEmpty()) {
            acceleratorDelimiter = " ";
        }
        if (modifiers > 0) {
            String keyModifiersText = KeyEvent.getModifiersExText(modifiers);
            if (CommonPlatformUtil.isMacOS()) {
                keyModifiersText = keyModifiersText.replace("Meta", "Cmd");
            }
            buffer.append(keyModifiersText);
            buffer.append(acceleratorDelimiter);
        }
    }

    private static class ComponentAction
    extends AbstractAction {
        private Component component;
        private ActionListener actionListener;
        private String actionCommand;

        public ComponentAction(@NotNull Component component, ActionListener actionListener, String actionCommand) {
            this.component = component;
            this.actionListener = actionListener;
            this.actionCommand = actionCommand;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.component.isEnabled()) {
                this.actionListener.actionPerformed(new ActionEvent(this.component, event.getID(), this.actionCommand == null ? event.getActionCommand() : this.actionCommand, event.getModifiers()));
            }
        }
    }
}

