/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.BinaryUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PE32Handler {
    private RandomAccessFile raFile;
    private boolean pe32Plus;
    private Machine machine;
    public static final int IMAGE_FILE_MACHINE_AMD64 = 34404;
    public static final int IMAGE_FILE_MACHINE_ARM64 = 43620;
    public static final int IMAGE_FILE_MACHINE_I386 = 332;

    @NotNull
    public static Machine getMachine(File file) throws IOException {
        try (RandomAccessFile raFile = new RandomAccessFile(file, "r");){
            PE32Handler pe32Handler = new PE32Handler();
            pe32Handler.initRaFile(raFile);
            Machine machine = pe32Handler.getMachine();
            return machine;
        }
    }

    protected final int initRaFile(RandomAccessFile raFile) throws IOException {
        this.raFile = raFile;
        if (raFile.length() < 64L || this.read() != 77 || this.read() != 90) {
            throw new IOException("no PE32 file");
        }
        raFile.seek(60L);
        int peHeaderOffset = this.readInt();
        if (raFile.length() < (long)(peHeaderOffset + 160)) {
            throw new IOException("file too short (PE)");
        }
        raFile.seek(peHeaderOffset);
        if (!Arrays.equals(new byte[]{80, 69, 0, 0}, this.readBytes(4))) {
            throw new IOException("PE header not found");
        }
        this.machine = PE32Handler.getMachine(this.readUnsignedShort());
        raFile.seek(peHeaderOffset + 24);
        this.pe32Plus = this.readShort() == 523;
        return peHeaderOffset;
    }

    @NotNull
    static Machine getMachine(int machine) {
        switch (machine) {
            case 34404: {
                return Machine.X64;
            }
            case 43620: {
                return Machine.ARM64;
            }
            case 332: {
                return Machine.I386;
            }
        }
        return Machine.UNKNOWN;
    }

    public boolean isPe32Plus() {
        return this.pe32Plus;
    }

    public Machine getMachine() {
        return this.machine;
    }

    protected final byte[] readBytes(int count) throws IOException {
        byte[] ret = new byte[count];
        this.raFile.readFully(ret);
        return ret;
    }

    protected final int read() throws IOException {
        return this.raFile.read();
    }

    protected final void writeInt(int val) throws IOException {
        this.raFile.writeInt(BinaryUtil.swap(val));
    }

    protected final int readInt() throws IOException {
        return BinaryUtil.swap(this.raFile.readInt());
    }

    protected final short readShort() throws IOException {
        return BinaryUtil.swap(this.raFile.readShort());
    }

    protected final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.raFile.read();
        if ((ch1 | (ch2 = this.raFile.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    protected final void writeUnsignedInt(long v) throws IOException {
        this.raFile.write((int)(v >>> 0 & 0xFFL));
        this.raFile.write((int)(v >>> 8 & 0xFFL));
        this.raFile.write((int)(v >>> 16 & 0xFFL));
        this.raFile.write((int)(v >>> 24 & 0xFFL));
    }

    protected final long readUnsignedInt() throws IOException {
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.raFile.read();
        if ((ch1 | (ch2 = (long)this.raFile.read()) | (ch3 = (long)this.raFile.read()) | (ch4 = (long)this.raFile.read())) < 0L) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public static Machine getJREMachine() {
        if (InstallerUtil.isAaarch64()) {
            return Machine.ARM64;
        }
        if (InstallerUtil.is32BitJVM()) {
            return Machine.I386;
        }
        return Machine.X64;
    }

    public static enum Machine {
        I386,
        X64,
        ARM64,
        UNKNOWN;

    }
}

