/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Install4jClassLoader
extends URLClassLoader {
    private static Install4jClassLoader instance = new Install4jClassLoader();
    private static boolean customJarsInitialized = false;
    private Map<String, Class<?>> parentCache = new HashMap();
    private List<URL> addedURLs = new ArrayList<URL>();
    private Class<?> customCodeInvoker;

    public static Install4jClassLoader getInstance() {
        if (!InstallerUtil.isInProcess()) {
            Thread.currentThread().setContextClassLoader(instance);
        }
        return instance;
    }

    public static void clear() {
        instance = new Install4jClassLoader();
    }

    private Install4jClassLoader() {
        super(new URL[0], Install4jClassLoader.class.getClassLoader());
    }

    public void addFile(File file) {
        try {
            this.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addURL(URL url) {
        this.addedURLs.add(url);
        super.addURL(url);
    }

    @Nullable
    public URL getResourceWithoutParent(@NotNull String name) {
        return this.findResource(name);
    }

    public List<URL> getAddedURLs() {
        return this.addedURLs;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (Objects.equals(name, CustomCodeInvoker.class.getName())) {
            if (this.customCodeInvoker == null) {
                this.customCodeInvoker = this.defineRuntimeClass(name);
            }
            return this.customCodeInvoker;
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.parentCache.get(name);
        }
        if (c == null) {
            if (name.startsWith("com.install4j.runtime.flatlaf.")) {
                c = this.defineRuntimeClass(name);
            } else if (name.startsWith("com.install4j.runtime.") || name.startsWith("com.install4j.api.") || name.startsWith("com.exe4j.") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.") || name.startsWith("sun.") || name.startsWith("jdk.") || name.startsWith("org.w3c.") || name.startsWith("org.xml.")) {
                c = super.loadClass(name, resolve);
                this.parentCache.put(name, c);
            } else {
                try {
                    c = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                    this.parentCache.put(name, c);
                }
            }
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> defineRuntimeClass(String name) throws ClassNotFoundException {
        InputStream inputStream = Install4jClassLoader.class.getClassLoader().getResourceAsStream(name.replace('.', '/') + ".class");
        if (inputStream == null) {
            throw new ClassNotFoundException(name);
        }
        try (InputStream ignored = inputStream;){
            byte[] data = FileUtil.readAllBytes(inputStream);
            Class<?> clazz = this.defineClass(name, data, 0, data.length);
            return clazz;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            throw new ClassNotFoundException(name);
        }
    }

    public static void addCustomJarsToClasspath(Context context) {
        File[] userFiles;
        if (customJarsInitialized) {
            return;
        }
        customJarsInitialized = true;
        Install4jClassLoader.addClassPathInt(new File(ResourceHelper.getRuntimeDir(), "user.jar"));
        File flatlafJarFile = new File(ResourceHelper.getRuntimeDir(), "flatlaf.jar");
        if (flatlafJarFile.isFile()) {
            Install4jClassLoader.addClassPathInt(flatlafJarFile);
        }
        if ((userFiles = new File(ResourceHelper.getRuntimeDir(), "user").listFiles()) != null) {
            for (File userFile : userFiles) {
                if (!userFile.getName().endsWith(".jar") && !userFile.getName().endsWith(".zip")) continue;
                Install4jClassLoader.addClassPathInt(userFile);
            }
        }
        if (!InstallerConfig.isInstaller()) {
            List<String> customJars = InstallerConfig.getCurrentInstance().getCustomJars();
            for (String customJar : customJars) {
                File destinationFile = context.getDestinationFile(customJar);
                if (destinationFile == null) continue;
                Install4jClassLoader.addClassPathInt(destinationFile);
            }
        }
    }

    public static void addClassPath(File file) {
        HelperCommunication.getInstance().runAction(ExecutionContext.ALL, context -> Install4jClassLoader.addClassPathInt(file));
    }

    private static void addClassPathInt(File file) {
        try {
            Install4jClassLoader.getInstance().addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void initHelperState() {
        List urls = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> Install4jClassLoader.getInstance().getAddedURLs());
        for (URL url : urls) {
            Install4jClassLoader.getInstance().addURL(url);
        }
    }

    public static Object invokeInCustomClassLoader(Method method, Object object, Object ... args) throws Throwable {
        Class<?> invokerClass = Install4jClassLoader.getInstance().loadClass(CustomCodeInvoker.class.getName(), true);
        try {
            return ((InvocationHandler)invokerClass.newInstance()).invoke(object, method, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static class CustomCodeInvoker
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(proxy, args);
        }
    }
}

