/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.ejt.internal.gui.KeyboardUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.styles.ControlButton;
import com.install4j.runtime.beans.formcomponents.ButtonWrapper;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.beans.widgets.ButtonWidgetStyle;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class StandardControlButtonComponent
extends SystemFormComponent
implements ControlButton {
    public static final String PREVIOUS_BUTTON_NAME = "previous";
    public static final String NEXT_BUTTON_NAME = "next";
    public static final String CANCEL_BUTTON_NAME = "cancel";
    private static final Object ORIGINAL_SIZE = "originalSize";
    private ControlButtonType controlButtonType;
    private String buttonText;
    private ExternalFile buttonIconFile;
    private String widgetStyleId = "";
    private ButtonWidgetStyle widgetStyle = new ButtonWidgetStyle();
    private ButtonWrapper buttonWrapper = new ButtonWrapper(this);

    @Override
    public ControlButtonType getControlButtonType() {
        return this.replaceWithTextOverride("controlButtonType", this.controlButtonType, ControlButtonType.class);
    }

    @Override
    public void focusControlButton() {
        this.buttonWrapper.getButton().requestFocus();
    }

    public void setControlButtonType(ControlButtonType controlButtonType) {
        this.controlButtonType = controlButtonType;
    }

    public String getButtonText() {
        return StandardControlButtonComponent.replaceVariables(this.buttonText);
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public ExternalFile getButtonIconFile() {
        return this.replaceWithTextOverride("buttonIconFile", this.buttonIconFile, ExternalFile.class);
    }

    public void setButtonIconFile(ExternalFile buttonIconFile) {
        this.buttonIconFile = buttonIconFile;
    }

    public String getWidgetStyleId() {
        return StandardControlButtonComponent.replaceVariables(this.widgetStyleId);
    }

    public void setWidgetStyleId(String widgetStyleId) {
        this.widgetStyleId = widgetStyleId;
    }

    public ButtonWidgetStyle getWidgetStyle() {
        return this.replaceWithTextOverride("widgetStyle", this.widgetStyle, ButtonWidgetStyle.class);
    }

    public void setWidgetStyle(ButtonWidgetStyle widgetStyle) {
        this.widgetStyle = widgetStyle;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.buttonWrapper.initialize(this.getButtonText(), this.getButtonName());
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        this.buttonWrapper.setFormEnvironment(formEnvironment);
    }

    @Override
    public JComponent createCenterComponent() {
        return this.buttonWrapper.createCenterComponent(this.getContext(), this.getButtonIconFile(), this.getWidgetStyleId(), this.getWidgetStyle(), this.getFormEnvironment(), e -> {
            if (this.isEnabled() && this.isVisible()) {
                this.getContext().getWizardContext().pressControlButton(this.getControlButtonType());
            }
        });
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.buttonWrapper.getButton();
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JButton.class;
    }

    @Override
    public boolean handleConsole(Console console) {
        return true;
    }

    @Override
    public void setControlButtonText(String text) {
        JButton button = this.buttonWrapper.getButton();
        Dimension originalSize = (Dimension)button.getClientProperty(ORIGINAL_SIZE);
        Dimension preferredSize = button.getPreferredSize();
        if (originalSize == null) {
            originalSize = (Dimension)preferredSize.clone();
            button.putClientProperty(ORIGINAL_SIZE, originalSize);
        }
        button.setPreferredSize(null);
        button.setText(text);
        preferredSize.width = Math.max(button.getPreferredSize().width, originalSize.width);
        button.setPreferredSize(preferredSize);
        button.setMinimumSize(preferredSize);
        button.setMaximumSize(preferredSize);
    }

    @Override
    public void formActivated() {
        super.formActivated();
        WizardScreen wizardScreen = (WizardScreen)SwingUtilities.getAncestorOfClass(WizardScreen.class, this.buttonWrapper.getButton());
        if (wizardScreen != null) {
            KeyboardUtil.addAccelerator(1, this.buttonWrapper.getButton(), wizardScreen, this.buttonWrapper.getActionListener(), this.getKeyCode(), this.getKeyMask());
        }
    }

    private int getKeyCode() {
        switch (this.getControlButtonType()) {
            case PREVIOUS: {
                return 37;
            }
            case NEXT: {
                return 39;
            }
            case CANCEL: {
                return 27;
            }
        }
        throw new IllegalStateException(this.getControlButtonType().name());
    }

    private int getKeyMask() {
        switch (this.getControlButtonType()) {
            case PREVIOUS: 
            case NEXT: {
                return Util.isMacOS() ? 10 : 8;
            }
            case CANCEL: {
                return 0;
            }
        }
        throw new IllegalStateException(this.getControlButtonType().name());
    }

    private int getAlternateKeyMask() {
        switch (this.getControlButtonType()) {
            case PREVIOUS: 
            case NEXT: {
                return 10;
            }
            case CANCEL: {
                return 0;
            }
        }
        throw new IllegalStateException(this.getControlButtonType().name());
    }

    private String getButtonName() {
        switch (this.getControlButtonType()) {
            case PREVIOUS: {
                return PREVIOUS_BUTTON_NAME;
            }
            case NEXT: {
                return NEXT_BUTTON_NAME;
            }
            case CANCEL: {
                return CANCEL_BUTTON_NAME;
            }
        }
        throw new IllegalStateException(this.getControlButtonType().name());
    }
}

