/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.internal.util;

import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public final class Util {
    private static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };

    private Util() {
    }

    public static HttpURLConnection createHttpConnection(URL endpointUrl, String httpMethod, Map<String, String> headers, int connectTimeoutMs, int readTimeoutMs) throws IOException {
        Preconditions.checkNotNull(headers);
        HttpURLConnection connection = (HttpURLConnection)endpointUrl.openConnection();
        connection.setRequestMethod(httpMethod);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(connectTimeoutMs);
        connection.setReadTimeout(readTimeoutMs);
        return connection;
    }

    public static String canonicalMetadataKey(String meta) {
        StringBuilder b = new StringBuilder();
        String s = meta.toLowerCase(Locale.ENGLISH);
        for (char ch : s.toCharArray()) {
            if (!Character.isDigit((int)ch) && !Character.isAlphabetic(ch)) continue;
            b.append(ch);
        }
        return b.toString();
    }

    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    public static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlEncode(String url, boolean keepPathSlash) {
        return Util.urlEncode(url, keepPathSlash, "UTF-8");
    }

    static String urlEncode(String url, boolean keepPathSlash, String charset) {
        String encoded;
        try {
            encoded = URLEncoder.encode(url, charset).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (keepPathSlash) {
            return encoded.replace("%2F", "/");
        }
        return encoded;
    }

    public static byte[] sha256(String text) {
        return Util.sha256(text.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha256(byte[] data) {
        return Util.hash(data, "SHA-256");
    }

    static byte[] hash(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readBytesAndClose(InputStream in) {
        try {
            int n;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            while ((n = in.read(buffer)) != -1) {
                bytes.write(buffer, 0, n);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static final InputStream emptyInputStream() {
        return EMPTY_INPUT_STREAM;
    }

    public static Optional<String> jsonFieldText(String json, String fieldName) {
        int valueStart;
        String key = "\"" + fieldName + "\"";
        int keyPosition = json.indexOf(key);
        if (keyPosition == -1) {
            return Optional.empty();
        }
        int colonPosition = json.indexOf(":", keyPosition + key.length());
        if (colonPosition == -1) {
            return Optional.empty();
        }
        for (valueStart = colonPosition + 1; valueStart < json.length() && Character.isWhitespace(json.charAt(valueStart)); ++valueStart) {
        }
        boolean isString = json.charAt(valueStart) == '\"';
        StringBuilder value = new StringBuilder();
        boolean isEscaped = false;
        for (int i = valueStart + (isString ? 1 : 0); i < json.length(); ++i) {
            char c = json.charAt(i);
            if (isString) {
                if (isEscaped) {
                    value.append(c);
                    isEscaped = false;
                    continue;
                }
                if (c == '\\') {
                    isEscaped = true;
                    continue;
                }
                if (c == '\"') break;
                value.append(c);
                continue;
            }
            if (c == ',' || c == '}') break;
            value.append(c);
        }
        String v = value.toString().trim();
        if (!isString && "null".equals(v)) {
            return Optional.empty();
        }
        return Optional.of(v);
    }
}

