/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.internal.auth;

import com.github.davidmoten.aws.lw.client.internal.Clock;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import com.github.davidmoten.aws.lw.client.internal.util.Util;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class AwsSignatureVersion4 {
    static final String ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    public static final String SCHEME = "AWS4";
    public static final String ALGORITHM = "HMAC-SHA256";
    public static final String TERMINATOR = "aws4_request";
    private static final String ISO8601BasicFormat = "yyyyMMdd'T'HHmmss'Z'";
    private static final String DateStringFormat = "yyyyMMdd";

    private AwsSignatureVersion4() {
    }

    public static String computeSignatureForQueryAuth(URL endpointUrl, String httpMethod, String serviceName, Optional<String> regionName, Clock clock, Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey, Optional<String> sessionToken) {
        Date now = new Date(clock.time());
        String dateTimeStamp = AwsSignatureVersion4.dateTimeFormat().format(now);
        String hostHeader = endpointUrl.getHost();
        int port = endpointUrl.getPort();
        if (port > -1) {
            hostHeader = hostHeader.concat(":" + port);
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AwsSignatureVersion4.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AwsSignatureVersion4.getCanonicalizedHeaderString(headers);
        String dateStamp = AwsSignatureVersion4.dateStampFormat().format(now);
        String scope = dateStamp + "/" + regionName.orElse("us-east-1") + "/" + serviceName + "/" + TERMINATOR;
        queryParameters.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        queryParameters.put("X-Amz-Credential", awsAccessKey + "/" + scope);
        queryParameters.put("X-Amz-Date", dateTimeStamp);
        queryParameters.put("X-Amz-SignedHeaders", canonicalizedHeaderNames);
        if (sessionToken.isPresent()) {
            queryParameters.put("X-Amz-Security-Token", sessionToken.get());
        }
        String canonicalizedQueryParameters = AwsSignatureVersion4.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AwsSignatureVersion4.getCanonicalRequest(endpointUrl, httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String stringToSign = AwsSignatureVersion4.getStringToSign(SCHEME, ALGORITHM, dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = (SCHEME + awsSecretKey).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AwsSignatureVersion4.sign(dateStamp, kSecret);
        byte[] kRegion = AwsSignatureVersion4.sign(regionName.orElse("us-east-1"), kDate);
        byte[] kService = AwsSignatureVersion4.sign(serviceName, kRegion);
        byte[] kSigning = AwsSignatureVersion4.sign(TERMINATOR, kService);
        byte[] signature = AwsSignatureVersion4.sign(stringToSign, kSigning);
        StringBuilder authString = new StringBuilder();
        authString.append("X-Amz-Algorithm=" + queryParameters.get("X-Amz-Algorithm"));
        authString.append("&X-Amz-Credential=" + queryParameters.get("X-Amz-Credential"));
        authString.append("&X-Amz-Date=" + queryParameters.get("X-Amz-Date"));
        authString.append("&X-Amz-Expires=" + queryParameters.get("X-Amz-Expires"));
        authString.append("&X-Amz-SignedHeaders=" + queryParameters.get("X-Amz-SignedHeaders"));
        authString.append("&X-Amz-Signature=" + Util.toHex(signature));
        if (sessionToken.isPresent()) {
            authString.append("&X-Amz-Security-Token=" + Util.urlEncode(sessionToken.get(), false));
        }
        return authString.toString();
    }

    public static String computeSignatureForAuthorizationHeader(URL endpointUrl, String httpMethod, String serviceName, String regionName, Clock clock, Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Preconditions.checkNotNull(headers);
        Preconditions.checkNotNull(queryParameters);
        SimpleDateFormat dateTimeFormat = AwsSignatureVersion4.dateTimeFormat();
        SimpleDateFormat dateStampFormat = AwsSignatureVersion4.dateStampFormat();
        Date now = new Date(clock.time());
        String dateTimeStamp = dateTimeFormat.format(now);
        headers.put("x-amz-date", dateTimeStamp);
        String hostHeader = endpointUrl.getHost();
        int port = endpointUrl.getPort();
        if (port > -1) {
            hostHeader = hostHeader.concat(":" + port);
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AwsSignatureVersion4.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AwsSignatureVersion4.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AwsSignatureVersion4.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AwsSignatureVersion4.getCanonicalRequest(endpointUrl, httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = dateStampFormat.format(now);
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + TERMINATOR;
        String stringToSign = AwsSignatureVersion4.getStringToSign(SCHEME, ALGORITHM, dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = (SCHEME + awsSecretKey).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AwsSignatureVersion4.sign(dateStamp, kSecret);
        byte[] kRegion = AwsSignatureVersion4.sign(regionName, kDate);
        byte[] kService = AwsSignatureVersion4.sign(serviceName, kRegion);
        byte[] kSigning = AwsSignatureVersion4.sign(TERMINATOR, kService);
        byte[] signature = AwsSignatureVersion4.sign(stringToSign, kSigning);
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + Util.toHex(signature);
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        return authorizationHeader;
    }

    static SimpleDateFormat dateTimeFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat(ISO8601BasicFormat);
        sdf.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return sdf;
    }

    static SimpleDateFormat dateStampFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat(DateStringFormat);
        sdf.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return sdf;
    }

    static String getCanonicalizeHeaderNames(Map<String, String> headers) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(headers.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(header.toLowerCase(Locale.ENGLISH));
        }
        return buffer.toString();
    }

    static String getCanonicalizedHeaderString(Map<String, String> headers) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(headers.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String key : sortedHeaders) {
            buffer.append(key.toLowerCase(Locale.ENGLISH).replaceAll("\\s+", " ") + ":" + headers.get(key).replaceAll("\\s+", " "));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    static String getCanonicalRequest(URL endpoint, String httpMethod, String canonicalQueryParameters, String canonicalizedHeaderNames, String canonicalizedHeaders, String bodyHash) {
        return httpMethod + "\n" + AwsSignatureVersion4.getCanonicalizedResourcePath(endpoint) + "\n" + canonicalQueryParameters + "\n" + canonicalizedHeaders + "\n" + canonicalizedHeaderNames + "\n" + bodyHash;
    }

    static String getCanonicalizedResourcePath(URL endpoint) {
        Preconditions.checkNotNull(endpoint);
        String path = endpoint.getPath();
        if (path.isEmpty()) {
            return "/";
        }
        return Util.urlEncode(path, true);
    }

    static String getCanonicalizedQueryString(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<String, String> pair2 : parameters.entrySet()) {
            sorted.put(Util.urlEncode(pair2.getKey(), false), pair2.getValue() == null ? null : Util.urlEncode(pair2.getValue(), false));
        }
        return sorted.entrySet().stream().map(pair -> (String)pair.getKey() + "=" + AwsSignatureVersion4.blankIfNull((String)pair.getValue())).collect(Collectors.joining("&"));
    }

    private static String blankIfNull(String s) {
        return s == null ? "" : s;
    }

    static String getStringToSign(String scheme, String algorithm, String dateTime, String scope, String canonicalRequest) {
        return scheme + "-" + algorithm + "\n" + dateTime + "\n" + scope + "\n" + Util.toHex(Util.sha256(canonicalRequest));
    }

    static byte[] sign(String stringData, byte[] key) {
        return AwsSignatureVersion4.sign(stringData, key, ALGORITHM_HMAC_SHA256);
    }

    static byte[] sign(String stringData, byte[] key, String algorithm) {
        try {
            byte[] data = stringData.getBytes(StandardCharsets.UTF_8);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

