/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.internal;

import com.github.davidmoten.aws.lw.client.MaxAttemptsExceededException;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.Callable;
import java.util.function.Predicate;

public final class Retries<T> {
    private final long initialIntervalMs;
    private final int maxAttempts;
    private final double backoffFactor;
    private final long maxIntervalMs;
    private final double jitter;
    private final Predicate<? super T> valueShouldRetry;
    private final Predicate<? super Throwable> throwableShouldRetry;

    public Retries(long initialIntervalMs, int maxAttempts, double backoffFactor, double jitter, long maxIntervalMs, Predicate<? super T> valueShouldRetry, Predicate<? super Throwable> throwableShouldRetry) {
        Preconditions.checkArgument(jitter >= 0.0 && jitter <= 1.0, "jitter must be between 0 and 1 inclusive");
        this.initialIntervalMs = initialIntervalMs;
        this.maxAttempts = maxAttempts;
        this.backoffFactor = backoffFactor;
        this.jitter = jitter;
        this.maxIntervalMs = maxIntervalMs;
        this.valueShouldRetry = valueShouldRetry;
        this.throwableShouldRetry = throwableShouldRetry;
    }

    public static <T> Retries<T> create(Predicate<? super T> valueShouldRetry, Predicate<? super Throwable> throwableShouldRetry) {
        return new Retries<T>(100L, 4, 2.0, 0.0, 20000L, valueShouldRetry, throwableShouldRetry);
    }

    public T call(Callable<T> callable) {
        return this.call(callable, this.valueShouldRetry);
    }

    public <S> S call(Callable<S> callable, Predicate<? super S> valueShouldRetry) {
        long intervalMs = this.initialIntervalMs;
        int attempt = 0;
        while (true) {
            block7: {
                try {
                    ++attempt;
                    S value = callable.call();
                    if (!valueShouldRetry.test(value)) {
                        return value;
                    }
                    if (Retries.reachedMaxAttempts(attempt, this.maxAttempts)) {
                        return value;
                    }
                }
                catch (Throwable t) {
                    if (!this.throwableShouldRetry.test(t)) {
                        Retries.rethrow(t);
                    }
                    if (!Retries.reachedMaxAttempts(attempt, this.maxAttempts)) break block7;
                    throw new MaxAttemptsExceededException("exceeded max attempts " + this.maxAttempts, t);
                }
            }
            Retries.sleep(intervalMs);
            intervalMs = Math.round(this.backoffFactor * (double)intervalMs);
            if (this.maxIntervalMs > 0L) {
                intervalMs = Math.min(this.maxIntervalMs, intervalMs);
            }
            intervalMs = Math.round((1.0 - this.jitter * Math.random()) * (double)intervalMs);
        }
    }

    static boolean reachedMaxAttempts(int attempt, int maxAttempts) {
        return maxAttempts > 0 && attempt >= maxAttempts;
    }

    static void sleep(long intervalMs) {
        try {
            Thread.sleep(intervalMs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <S> Retries<S> withValueShouldRetry(Predicate<? super S> valueShouldRetry) {
        return new Retries<S>(this.initialIntervalMs, this.maxAttempts, this.backoffFactor, this.jitter, this.maxIntervalMs, valueShouldRetry, this.throwableShouldRetry);
    }

    public Retries<T> withInitialIntervalMs(long initialIntervalMs) {
        return new Retries<T>(initialIntervalMs, this.maxAttempts, this.backoffFactor, this.jitter, this.maxIntervalMs, this.valueShouldRetry, this.throwableShouldRetry);
    }

    public Retries<T> withMaxAttempts(int maxAttempts) {
        return new Retries<T>(this.initialIntervalMs, maxAttempts, this.backoffFactor, this.jitter, this.maxIntervalMs, this.valueShouldRetry, this.throwableShouldRetry);
    }

    public Retries<T> withBackoffFactor(double backoffFactor) {
        return new Retries<T>(this.initialIntervalMs, this.maxAttempts, backoffFactor, this.jitter, this.maxIntervalMs, this.valueShouldRetry, this.throwableShouldRetry);
    }

    public Retries<T> withMaxIntervalMs(long maxIntervalMs) {
        return new Retries<T>(this.initialIntervalMs, this.maxAttempts, this.backoffFactor, this.jitter, maxIntervalMs, this.valueShouldRetry, this.throwableShouldRetry);
    }

    public Retries<T> withJitter(double jitter) {
        return new Retries<T>(this.initialIntervalMs, this.maxAttempts, this.backoffFactor, jitter, this.maxIntervalMs, this.valueShouldRetry, this.throwableShouldRetry);
    }

    public Retries<T> withThrowableShouldRetry(Predicate<? super Throwable> throwableShouldRetry) {
        return new Retries<T>(this.initialIntervalMs, this.maxAttempts, this.backoffFactor, this.jitter, this.maxIntervalMs, this.valueShouldRetry, throwableShouldRetry);
    }

    public Retries<T> copy() {
        return new Retries<T>(this.initialIntervalMs, this.maxAttempts, this.backoffFactor, this.jitter, this.maxIntervalMs, this.valueShouldRetry, this.throwableShouldRetry);
    }

    static void rethrow(Throwable t) throws Error {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            throw new UncheckedIOException((IOException)t);
        }
        throw new RuntimeException(t);
    }
}

