package com.install4j.api.windows;

import com.install4j.runtime.installer.platform.win32.Registry;

/**
 * Enumeration class for the different registry roots in the Microsoft Windows registry.

 * @author ej-technologies GmbH
 */
public enum RegistryRoot {

    /**
     * Identifies the root registry key {@code HKEY_CLASSES_ROOT}.
     */
    HKEY_CLASSES_ROOT(Registry.HKEY_CLASSES_ROOT, "HKEY_CLASSES_ROOT"),

    /**
     * Identifies the root registry key {@code HKEY_LOCAL_MACHINE}.
     */
    HKEY_LOCAL_MACHINE(Registry.HKEY_LOCAL_MACHINE, "HKEY_LOCAL_MACHINE"),

    /**
     * Identifies the root registry key {@code HKEY_CURRENT_USER}.
     */
    HKEY_CURRENT_USER(Registry.HKEY_CURRENT_USER, "HKEY_CURRENT_USER"),

    /**
     * Identifies the root registry key {@code HKEY_USERS}.
     */
    HKEY_USERS(Registry.HKEY_USERS, "HKEY_USERS"),

    /**
     * Identifies the root registry key {@code HKEY_CURRENT_CONFIG}.
     */
    HKEY_CURRENT_CONFIG(Registry.HKEY_CURRENT_CONFIG, "HKEY_CURRENT_CONFIG");

    private final transient int type;
    private final transient String name;

    RegistryRoot(int type, String name) {
        this.type = type;
        this.name = name;
    }

    int getType() {
        return type;
    }

    @Override
    public String toString() {
        return name;
    }

}
