package com.install4j.api.windows;

import com.install4j.runtime.installer.platform.win32.FolderInfo;

/**
 * Enumeration class for the different drive types a file can be located on.

 * @author ej-technologies GmbH
 */
public enum DriveType {

    /**
     * The drive type could not be determined.
     */
    UNKNOWN(FolderInfo.DRIVE_UNKNOWN, "unknown"),

    /**
     * A removable drive.
     */
    REMOVABLE(FolderInfo.DRIVE_REMOVABLE, "removable"),

    /**
     * A fixed (local) drive.
     */
    FIXED(FolderInfo.DRIVE_FIXED, "fixed"),

    /**
     * A remote (network) drive.
     */
    REMOTE(FolderInfo.DRIVE_REMOTE, "remote"),

    /**
     * A CD-ROM.
     */
    CDROM(FolderInfo.DRIVE_CDROM, "cdrom"),

    /**
     * A ram disk.
     */
    RAMDISK(FolderInfo.DRIVE_RAMDISK, "ramdisk");

    /**
     * Convert int value to constant.
     * @param value the int value
     * @return the constant
     */
    public static DriveType getFromIntValue(int value) {
        for (DriveType driveType : values()) {
            if (driveType.getIntValue() == value) {
                return driveType;
            }
        }
        return DriveType.UNKNOWN;
    }

    private final int intValue;
    private final String name;

    DriveType(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    /**
     * Convert to an int value.
     * @return the int value
     */
    public int getIntValue() {
        return intValue;
    }

    @Override
    public String toString() {
        return name;
    }

}
