package com.install4j.api.beans;

import java.io.Serializable;

/**
 * Property type for a configurable list of actions.
 * Configuration options are available by using {@link com.install4j.api.beaninfo.ActionListPropertyDescriptor} in
 * the BeanInfo class.
 */
public class ActionList implements Serializable {
    private String id;
    private boolean breakOnError = false;

    /**
     * Called by the framework.
     */
    public String getId() {
        return id;
    }

    /**
     * Called by the framework.
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * If the execution of the actions should be terminated when an action fails.
     * @return the value
     */
    public boolean isBreakOnError() {
        return breakOnError;
    }

    /**
     * Determines if the execution of the actions should be terminated when an action fails.
     * @param breakOnError the new value
     */
    public void setBreakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
    }
}
