package com.install4j.api.beaninfo;

import com.install4j.api.beans.Bean;

/**
 * Interface for controlling the visibility of child properties based on the value of the parent property.
 * This applies to properties that have been arranged in a tree-like structure by calling
 * {@link Install4JPropertyDescriptor#setParentProperty(String)} on their property descriptors.
 * If you register an implementation of this interface with
 * {@link Install4JPropertyDescriptor#setVisibilityDiscriminator(VisibilityDiscriminator)},
 * each time the value of the parent property changes, a callback will be made to
 * {@link #isVisible(Bean, Object)} in order to decide whether
 * the child property should be visible or not.
 * <p>
 * For boolean parent properties, if you not register a visibility discriminator, the children will be
 * hidden if the user selection of the parent property is {@code false}.
 * </p>
 */
public interface VisibilityDiscriminator {
    /**
     * Determine if the property for which this callback has been registered should be visible or not.
     * Each time the value of the parent property changes, this method will be called.
     * @param bean the bean to which both parent and child property belong
     * @param parentPropertyValue the value of the parent property
     * @return whether the child property should be visible or not
     */
    boolean isVisible(Bean bean, Object parentPropertyValue);
}
