package com.install4j.jdk.spi;

import org.jetbrains.annotations.NotNull;

import static com.install4j.jdk.spi.CommonArchitectures.*;
import static com.install4j.jdk.spi.CommonOperatingSystems.*;

/**
 * IDs for common platforms as used by {@link JdkReleaseNode} and {@link JdkProvider#getByConfigKey(String)}.
 * These ID must be used when available. Other platforms can use arbitrary strings.
 * <p>
 * A platform ID has the form {@code os-arch} where {@code os} is the operating system and
 * {@code arch} is the architecture. Corresponding values that are mandated by install4j are given in
 * {@link CommonOperatingSystems} and {@link CommonArchitectures}.
 * </p>
 */
public class CommonPlatforms {
    /**
     * 64-bit Windows
     */
    public static final String WINDOWS_AMD64 = createPlatform(WINDOWS, AMD64);

    /**
     * 32-bit Windows
     */
    public static final String WINDOWS_X86 = createPlatform(WINDOWS, X86);

    /**
     * aarch64 Windows
     */
    public static final String WINDOWS_AARCH64 = createPlatform(WINDOWS, AARCH64);

    /**
     * macOS Intel
     */
    public static final String MACOS_AMD64 = createPlatform(MACOS, AMD64);

    /**
     * macOS Apple Silicon
     */
    public static final String MACOS_AARCH64 = createPlatform(MACOS, AARCH64);

    /**
     * macOS Universal
     */
    public static final String MACOS_UNIVERSAL = createPlatform(MACOS, UNIVERSAL);

    /**
     * 64-bit amd64 Linux
     */
    public static final String LINUX_AMD64 = createPlatform(LINUX, AMD64);

    /**
     * 64-bit ARM Linux
     */
    public static final String LINUX_AARCH64 = createPlatform(LINUX, AARCH64);

    /**
     * 64-bit amd64 Alpine Linux
     */
    public static final String ALPINE_LINUX_AMD64 = createPlatform(ALPINE_LINUX, AMD64);

    /**
     * 64-bit ARM Alpine Linux
     */
    public static final String ALPINE_LINUX_ARM = createPlatform(ALPINE_LINUX, AARCH64);

    /**
     * 32-bit Linux
     */
    public static final String LINUX_X86 = createPlatform(LINUX, X86);

    @NotNull
    private static String createPlatform(String os, String arch) {
        return os + "-" + arch;
    }

    private CommonPlatforms() {
    }

}
