/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools.shadowed.ejt.gui;

import com.install4j.buildtools.shadowed.ejt.util.CommonPlatformUtil;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class CommonLookAndFeelUtil {
    public static final String INTER_FONT_FAMILY_NAME = "Inter";

    public static boolean isInterAvailable() {
        return CommonLookAndFeelUtil.isFontFamilyAvailable(INTER_FONT_FAMILY_NAME);
    }

    public static boolean isFontFamilyAvailable(String familyName) {
        return Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()).collect(Collectors.toSet()).contains(familyName);
    }

    public static void adjustDefaultFont(float userScaleFactor) {
        if (CommonLookAndFeelUtil.isInterAvailable()) {
            UIManager.put("defaultFont", UIManager.getFont("defaultFont").deriveFont(13.0f * userScaleFactor));
        }
    }

    @Nullable
    public static String getPreferredFontFamily() {
        if (CommonPlatformUtil.isLinux() && CommonLookAndFeelUtil.isInterAvailable()) {
            return INTER_FONT_FAMILY_NAME;
        }
        return null;
    }
}

