/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalUtils;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalIconFactory
implements Serializable {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component component, Graphics graphics, int n2, int n3) {
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            graphics.translate(n2, n3);
            int n4 = this.getIconWidth();
            int n5 = this.getIconHeight();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(0, 0, n4, n5);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.fillRect(0, 0, n4, 2);
                    graphics.fillRect(0, 2, 2, n5 - 2);
                    graphics.fillRect(n4 - 1, 1, 1, n5 - 1);
                    graphics.fillRect(1, n5 - 1, n4 - 2, 1);
                } else if (buttonModel.isRollover()) {
                    MetalUtils.drawGradient(component, graphics, "CheckBox.gradient", 0, 0, n4, n5, true);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawRect(1, 1, n4 - 3, n5 - 3);
                    graphics.drawRect(2, 2, n4 - 5, n5 - 5);
                } else {
                    MetalUtils.drawGradient(component, graphics, "CheckBox.gradient", 0, 0, n4, n5, true);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            }
            graphics.translate(-n2, -n3);
            if (buttonModel instanceof TristateButtonModel && ((TristateButtonModel)buttonModel).isMixed()) {
                this.drawSquare(component, graphics, n2, n3);
            } else if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n2, n3);
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanIcon(component, graphics, n2, n3);
                return;
            }
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            int n4 = this.getControlSize();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n2, n3, n4 - 1, n4 - 1);
                    MetalUtils.drawPressed3DBorder(graphics, n2, n3, n4, n4);
                } else {
                    MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n4);
                }
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n2, n3, n4 - 2, n4 - 2);
            }
            if (buttonModel instanceof TristateButtonModel && ((TristateButtonModel)buttonModel).isMixed()) {
                this.drawSquare(component, graphics, n2, n3);
            } else if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n2, n3);
            }
        }

        protected void drawCheck(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.getControlSize();
            graphics.fillRect(n2 + 3, n3 + 5, 2, n4 - 8);
            graphics.drawLine(n2 + (n4 - 4), n3 + 3, n2 + 5, n3 + (n4 - 6));
            graphics.drawLine(n2 + (n4 - 4), n3 + 4, n2 + 5, n3 + (n4 - 5));
        }

        protected void drawSquare(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.getControlSize();
            graphics.fillRect(n2 + 3, n3 + 3, n4 - 6, n4 - 6);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

