/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ColorFilter
extends RGBImageFilter {
    private boolean _brighter;
    private static int _percent = 30;
    private static ColorFilter _colorFilter;

    public static ColorFilter getInstance(boolean bl2, int n2) {
        if (_colorFilter == null) {
            _colorFilter = new ColorFilter(bl2, n2);
        } else {
            _colorFilter.setBrighter(bl2);
            ColorFilter.setPercent(n2);
        }
        return _colorFilter;
    }

    public void setBrighter(boolean bl2) {
        this._brighter = bl2;
    }

    public static void setPercent(int n2) {
        _percent = n2;
    }

    public static int getPercent() {
        return _percent;
    }

    public static Image createBrighterImage(Image image) {
        ColorFilter colorFilter = ColorFilter.getInstance(true, _percent);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), colorFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Image createBrighterImage(Image image, int n2) {
        ColorFilter.setPercent(n2);
        return ColorFilter.createBrighterImage(image);
    }

    public static Image createDarkerImage(Image image) {
        ColorFilter colorFilter = ColorFilter.getInstance(false, _percent);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), colorFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Image createDarkerImage(Image image, int n2) {
        ColorFilter.setPercent(n2);
        return ColorFilter.createDarkerImage(image);
    }

    public ColorFilter(boolean bl2, int n2) {
        this._brighter = bl2;
        _percent = n2;
        this.canFilterIndexColorModel = true;
    }

    @Override
    public int filterRGB(int n2, int n3, int n4) {
        int n5 = n4 >> 16 & 0xFF;
        int n6 = n4 >> 8 & 0xFF;
        int n7 = n4 & 0xFF;
        return n4 & 0xFF000000 | this.convert(n5) << 16 | this.convert(n6) << 8 | this.convert(n7);
    }

    private int convert(int n2) {
        n2 = this._brighter ? (n2 += (255 - n2) * _percent / 100) : (n2 -= (255 - n2) * _percent / 100);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        return n2;
    }
}

