/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.properties.AbstractPropertiesFileActionBeanInfo;
import com.install4j.runtime.beans.actions.properties.PropertiesSource;
import com.install4j.runtime.beans.actions.properties.WritePropertiesFileAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import java.util.Map;

@BeanInfo
public class WritePropertiesFileActionBeanInfo
extends AbstractPropertiesFileActionBeanInfo {
    public static final String DISPLAY_NAME = "Write properties to file";
    private static final String PROPERTY_LINE_SEPARATOR = "lineSeparator";
    private static final String PROPERTY_MERGE = "merge";
    private static final String DISPLAY_NAME_MERGE = "Merge into existing file";
    private static final String PROPERTY_UPDATE_EXISTING_KEYS = "updateExistingKeys";
    private static final String PROPERTY_UPDATE_EXISTING_COMMENTS = "updateExistingComments";
    private static final String PROPERTY_PROPERTIES_SOURCE = "propertiesSource";
    private static final String PROPERTY_SOURCE_PROPERTY_DEFINITIONS = "sourcePropertyDefinitions";
    private static final String PROPERTY_SOURCE_FILE = "sourceFile";
    private static final String PROPERTY_SOURCE_VARIABLE_NAME = "sourceVariableName";
    private static final String PROPERTY_REPLACE_INSTALLER_VARIABLES = "replaceInstallerVariables";
    private static final String PROPERTY_PROPERTIES_SORT_MODE = "propertiesSortMode";

    public WritePropertiesFileActionBeanInfo() {
        super(DISPLAY_NAME, "Write property definitions to a properties file. The properties can come from an installer variable with a <tt>java.util.Map</tt> object, another properties file or from direct entry.<p>If the \"Merge into existing file\" property is selected, the new property definitions will be added to the existing ones.</p>", WritePropertiesFileAction.class);
        this.addFileProperty("Properties file", "The properties file that will be written or modified.");
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_LINE_SEPARATOR, (Class)this.getBeanClass(), (String)"Line separator", (String)"The line separator that should be used for writing the properties file."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_MERGE, (Class)this.getBeanClass(), (String)DISPLAY_NAME_MERGE, (String)"If selected, and the properties file already exists, the file will be read first and the new property definitions will be added to the existing ones."));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_MERGE, Install4JPropertyDescriptor.create((String)PROPERTY_UPDATE_EXISTING_KEYS, (Class)this.getBeanClass(), (String)"Update existing keys", (String)"If selected, the values of existing keys will be updated with the new values.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_MERGE, Install4JPropertyDescriptor.create((String)PROPERTY_UPDATE_EXISTING_COMMENTS, (Class)this.getBeanClass(), (String)"Update existing comments", (String)"If selected, the comments of existing keys will be updated with the new comments. An existing comment will not be deleted if the new comment is empty.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_PROPERTIES_SOURCE, (Class)this.getBeanClass(), (String)"Source of property definitions", (String)"The source of the new property definitions that should be written to the properties file."));
        this.addPropertyDescriptor(this.reparentSource(PropertiesSource.DIRECT, Install4JPropertyDescriptor.create((String)PROPERTY_SOURCE_PROPERTY_DEFINITIONS, (Class)this.getBeanClass(), (String)"Property definitions", (String)"The new property definitions that should be written to the properties file. Comment lines starting with # and empty lines can be interspersed with the property definitions.", (String)"multiline")));
        this.addPropertyDescriptor(this.reparentSource(PropertiesSource.FILE, Install4JPropertyDescriptor.create((String)PROPERTY_SOURCE_FILE, (Class)this.getBeanClass(), (String)"Source properties file", (String)"The source file with the new property definitions that should be written to the target properties file. The encoding must be the same as that of the target properties file.", (String)"externalOrInternal")));
        this.addPropertyDescriptor(this.reparentSource(PropertiesSource.VARIABLE, Install4JPropertyDescriptor.create((String)PROPERTY_SOURCE_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Source variable name", (String)"The variable name with a <tt>java.util.Map</tt> object containing the new property definitions that should be written to the properties file. If the map was read by a \"Read a properties file\" action, the original comments will be used.", (String)"variableName").setVariableValueClass(Map.class)));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_REPLACE_INSTALLER_VARIABLES, (Class)this.getBeanClass(), (String)"Replace installer variables", (String)"If selected, installer variables written in the syntax <tt>${installer:variableName}</tt> will be replaced with their current values for all property values. If an installer variable does not exist, an error message will be inserted."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_PROPERTIES_SORT_MODE, (Class)this.getBeanClass(), (String)"Sort properties", (String)"This property determines where new properties should be inserted with respect to existing properties. If the keys are sorted, then existing and new properties are sorted together."));
    }

    private Install4JPropertyDescriptor reparentSource(PropertiesSource propertiesSource, Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_PROPERTIES_SOURCE);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> object == propertiesSource);
        return install4JPropertyDescriptor;
    }
}

