/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.properties.AbstractPropertiesFileActionBeanInfo;
import com.install4j.runtime.beans.actions.properties.ReadPropertiesFileAction;
import java.util.Map;

@BeanInfo
public class ReadPropertiesFileActionBeanInfo
extends AbstractPropertiesFileActionBeanInfo {
    public static final String DISPLAY_NAME = "Read a properties file";
    private static final String PROPERTY_VARIABLE_NAME = "variableName";
    private static final String PROPERTY_MERGE = "merge";

    public ReadPropertiesFileActionBeanInfo() {
        super(DISPLAY_NAME, "Read a properties file and save a <tt>java.util.Map</tt> object with the properties to an installer variable. If you use a \"Write properties to file\" action to write the variable back to disk, the comments on the existing property definitions will be preserved.", ReadPropertiesFileAction.class);
        this.addFileProperty("Properties file", "The properties file that will be read.");
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name", (String)"The name of the variable that will be set with an instance of <tt>java.util.Map</tt>. Enter the variable without the installer prefix and the dollar sign.", (String)PROPERTY_VARIABLE_NAME).setVariableValueClass(Map.class));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_MERGE, (Class)this.getBeanClass(), (String)"Merge into existing variable", (String)"If the variable already contains a value of type <tt>java.util.Map</tt>, the properties will be merged with the entries in that map. The actual map object after the action has run may be different, since install4j supplies a special map that can retain comments on property definitions."));
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.checkNotEmpty(PROPERTY_VARIABLE_NAME, bean);
    }
}

