/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.ejt.internal.util.ap;
import com.install4j.api.actions.Action;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.jdbc.AbstractJdbcActionBeanInfo;
import com.install4j.runtime.beans.actions.jdbc.ExecuteSqlScriptAction;
import com.install4j.runtime.beans.actions.jdbc.ScriptSource;
import java.util.List;

@BeanInfo
public class ExecuteSqlScriptActionBeanInfo
extends AbstractJdbcActionBeanInfo {
    private static final String PROPERTY_SCRIPT_SOURCE = "scriptSource";
    private static final String PROPERTY_SCRIPT = "script";
    private static final String PROPERTY_SCRIPT_FILE = "scriptFile";
    private static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_DELIMITER = "delimiter";
    public static final String PROPERTY_COMMIT_EACH_STATEMENT = "commitEachStatement";
    public static final String PROPERTY_IGNORE_ERRORS = "ignoreErrors";

    public ExecuteSqlScriptActionBeanInfo() {
        super("Execute SQL script", "Execute a single SQL statement or a script of SQL statements.", ExecuteSqlScriptAction.class);
        this.addPropertyDescriptor(this.categoryScript(Install4JPropertyDescriptor.create((String)PROPERTY_SCRIPT_SOURCE, (Class)this.getBeanClass(), (String)"Script source", (String)"You can either enter the SQL statements directly in the install4j IDE, or read a file that contains the SQL script. In both cases, installer variables will be replaced.")));
        String string = "Either a single SQL statement or a sequence of statements separated by the configured delimiter. Installer variables will be replaced before the execution.";
        this.addPropertyDescriptor(this.reparentScriptSource(ScriptSource.DIRECT, Install4JPropertyDescriptor.create((String)PROPERTY_SCRIPT, (Class)this.getBeanClass(), (String)"SQL script", (String)(string + " If no delimiter is found, the entire input is treated as a single SQL statement."), (String)"multiline")));
        this.addPropertyDescriptor(this.reparentScriptSource(ScriptSource.FILE, (Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_SCRIPT_FILE, (Class)this.getBeanClass(), (String)"SQL script file", (String)("A file containing the SQL script, " + ap.a(string) + "The file may also be gzipped (with the Unix gzip command line utility), the action will then automatically decompress the file on the fly."), (FileSelectionMode)FileSelectionMode.FILES_ONLY, (String)"externalOrInternal")));
        this.addPropertyDescriptor(this.reparentScriptSource(ScriptSource.FILE, Install4JPropertyDescriptor.create((String)PROPERTY_ENCODING, (Class)this.getBeanClass(), (String)"Encoding", (String)"The encoding of the file. If you leave this empty, the system default will be used. Common encodings are UTF-8, UTF-16, ISO-8859-1.")));
        this.addPropertyDescriptor(this.categoryScript(Install4JPropertyDescriptor.create((String)PROPERTY_DELIMITER, (Class)this.getBeanClass(), (String)"Statement delimiter", (String)"A regular expression that separates SQL statements. To match line breaks, enter <tt>$</tt>. If the delimited contains characters that have a special meaning in regular expressions, you have to quote them, like in <tt>\\.</tt> for a literal dot.")));
        this.addPropertyDescriptor(this.categoryScript(Install4JPropertyDescriptor.create((String)PROPERTY_COMMIT_EACH_STATEMENT, (Class)this.getBeanClass(), (String)"Commit each statement", (String)"If selected, each SQL statement will be committed separately. Otherwise, the entire script will be committed at the end. If the script contains a single statement, the setting has no effect.")));
        this.addPropertyDescriptor(this.categoryScript(Install4JPropertyDescriptor.create((String)PROPERTY_IGNORE_ERRORS, (Class)this.getBeanClass(), (String)"Ignore errors", (String)"If selected, errors from single SQL statements will be ignored, and processing will not be stopped. Otherwise, processing stops at the first error and a database rollback will be performed unless \"Commit each statement\" is selected.")));
        this.addErrorMessagesVariableNameProperty();
    }

    private Install4JPropertyDescriptor reparentScriptSource(ScriptSource scriptSource, Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_SCRIPT_SOURCE);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> object == scriptSource);
        return install4JPropertyDescriptor;
    }

    private Install4JPropertyDescriptor categoryScript(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Script Execution");
        return install4JPropertyDescriptor;
    }

    @Override
    protected Install4JPropertyDescriptor categoryMain(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        return this.categoryScript(install4JPropertyDescriptor);
    }

    @Override
    public void validateAction(Action action, List<String> list) throws BeanValidationException {
        super.validateAction(action, list);
        ScriptSource scriptSource = ((ExecuteSqlScriptAction)action).getScriptSource();
        switch (scriptSource) {
            case DIRECT: {
                this.checkNotEmpty(PROPERTY_SCRIPT, (Bean)action);
                break;
            }
            case FILE: {
                this.checkNotEmpty(PROPERTY_SCRIPT_FILE, (Bean)action);
            }
        }
    }
}

