/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.api.launcher.StartupNotification;
import com.install4j.c.d.e.e.l;
import com.install4j.config.h;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.desktop.UrlHandlerAction;
import com.install4j.runtime.beans.common.CategoryUtil;

@BeanInfo
public class UrlHandlerActionBeanInfo
extends SystemActionBeanInfo
implements BeanValidator {
    private static final String MACOS_NOTICE = "For macOS, URL handlers have to be defined on the \"Executable info->macOS options\" step of the launcher wizard.";
    public static final String NAME = "Register a URL handler";
    private static final String PROPERTY_SCHEME = "scheme";

    public UrlHandlerActionBeanInfo() {
        super(NAME, "Register a URL handler for a custom scheme, so that the launcher is invoked when the user clicks on a link with the specified scheme. <p>On Windows and Linux, the arguments to the main method will contain the URL. On macOS, the arguments are available from the <tt>" + StartupNotification.class.getName() + "</tt> class. If the \"Allow only a single running instance of the application\" check box is selected on the \"Java invocation\" step of the launcher wizard, subsequent invocations are intercepted by the <tt>" + StartupNotification.class.getName() + "</tt> class on all platforms.</p><p> This action will be automatically reverted by the 'Uninstall files' action.</p><p>For macOS, URL handlers have to be defined on the \"Executable info->macOS options\" step of the launcher wizard.</p>", "Desktop integration", true, true, null, UrlHandlerAction.class);
        this.setDefaultActionElevationType(ActionElevationType.ELEVATE, true);
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_SCHEME, (Class)this.getBeanClass(), (String)"Scheme", (String)"The scheme for which the URL handler should be created. Must not include the trailing colon. For example, the scheme <tt>hello</tt> will match URLs like <tt>hello://world</tt>.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)"launcherId", (Class)this.getBeanClass(), (String)"Launcher", (String)"The launcher that will be invoked.", (String)"nonServiceLauncher")));
        if (h.O().ac()) {
            this.setNoticePanel(new l(MACOS_NOTICE){

                @Override
                protected boolean isHidden() {
                    return h.O().Z();
                }

                @Override
                protected void saveHidden() {
                    h.O().n(false);
                }
            });
        }
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_SCHEME, bean);
        this.checkNotEmpty("launcherId", bean);
    }
}

