/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.UninstallFilesAction;
import com.install4j.runtime.beans.actions.services.InstallServiceAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.AppleScriptHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.MacNativeUtil;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.unix.ServiceFile;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.launcher.MacLauncher;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddStartupItemAction
extends SystemAutoUninstallInstallAction {
    private File executable;
    private String[] arguments;
    private String name;
    private boolean allUsers;
    private String macosIdentifier;
    private boolean hide = false;
    private boolean startImmediately = false;
    private boolean requireGraphicalSession = false;
    private static final String PROPNAME_EXECUTABLE = "executable";
    private static final String PROPNAME_MACOS_TYPE = "macosType";
    private static final String PROPNAME_MACOS_IDENTIFIER = "macosIdentifier";
    private static final String PROPNAME_MACOS_DOMAIN = "macosDomain";
    private static final String PROPNAME_UNIT_FILE = "unitFile";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        try {
            String[] arguments = this.getArguments();
            File destinationFile = context.getDestinationFile(this.getExecutable());
            if (InstallerUtil.isWindows()) {
                if (!destinationFile.exists()) {
                    destinationFile = context.getDestinationFile(this.getExecutable() + ".exe");
                }
                Logger.getInstance().info(this, "using " + destinationFile + ", " + destinationFile.exists());
                boolean allUsers = this.isAllUsers();
                if (allUsers && !InstallerUtil.checkWritable(FolderInfo.getSpecialFolder(4, true))) {
                    allUsers = false;
                }
                MenuHelper.installWindowsMenu(allUsers ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, new File(FolderInfo.getSpecialFolder(4, allUsers), this.getName()), destinationFile, null, StringUtil.makeCommandLine(arguments), false, null);
                if (!this.isStartImmediately() || !destinationFile.isFile() || LaunchHelper.launchFinishExecutable(destinationFile, arguments, destinationFile.getParentFile(), ExecutionContext.UNELEVATED)) return true;
                Logger.getInstance().error(this, "Could not start " + destinationFile);
                return true;
            } else if (InstallerUtil.isMacOS()) {
                Logger.getInstance().info(this, "using " + destinationFile + ", " + destinationFile.exists());
                if (!AddStartupItemAction.removeLegacyLoginItem(context, destinationFile) && context.getBooleanVariable("sys.ext.failOnLegacyLoginItemError")) {
                    return false;
                }
                Properties successProperties = AddStartupItemAction.addOnMac(this.getMacosIdentifier(), destinationFile, arguments, this.isHide(), this.isStartImmediately());
                if (successProperties == null) return false;
                this.getPersistentProperties().putAll((Map<?, ?>)successProperties);
                return true;
            } else {
                Logger.getInstance().info(this, "using " + destinationFile + ", " + destinationFile.exists());
                Properties successProperties = this.addOnLinux(destinationFile, arguments);
                if (successProperties == null) return false;
                this.getPersistentProperties().putAll((Map<?, ?>)successProperties);
            }
            return true;
        }
        catch (IOException e) {
            Logger.getImpl().log(e);
            return false;
        }
    }

    private Properties addOnLinux(File destinationFile, String[] arguments) {
        Properties properties = null;
        if (InstallServiceAction.isSystemdFilesAvailable()) {
            String userDir = ".config/systemd/user";
            boolean useSystemd = HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> {
                try {
                    return new File(System.getProperty("user.home"), userDir).isDirectory() && Execution.executeAndWait(new String[]{"/usr/bin/systemctl", "--user", "--version"}, new StringBuffer());
                }
                catch (Exception e) {
                    Logger.getInstance().log(e);
                    return false;
                }
            });
            if (useSystemd) {
                ArrayList<String> clList = new ArrayList<String>();
                clList.add(destinationFile.getAbsolutePath());
                clList.addAll(Arrays.asList(arguments));
                String commandLine = StringUtil.makeCommandLine(clList.toArray(new String[0]));
                int systemdVersion = ServiceHandler.getSystemdVersion();
                String name = destinationFile.getName();
                ServiceFile serviceFile = ServiceFile.createForUser(commandLine, name, systemdVersion >= 240, this.isRequireGraphicalSession());
                String serviceFileContent = serviceFile.toString();
                boolean startImmediately = this.isStartImmediately();
                properties = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> {
                    File configFile = new File(new File(System.getProperty("user.home"), userDir), name + ".service");
                    Logger.getInstance().info(null, "systemd unit file  " + configFile);
                    Files.write(configFile.toPath(), serviceFileContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    if (InstallServiceAction.reloadSystemCtl(true)) {
                        InstallServiceAction.callSystemCtl(true, name, "enable");
                        if (startImmediately) {
                            InstallServiceAction.callSystemCtl(true, name, "start");
                        }
                    }
                    Properties systemdProps = new Properties();
                    systemdProps.setProperty(PROPNAME_UNIT_FILE, configFile.getAbsolutePath());
                    systemdProps.setProperty(PROPNAME_EXECUTABLE, destinationFile.getAbsolutePath());
                    return systemdProps;
                });
            } else {
                Logger.getInstance().info(this, "systemd user session not found");
            }
        } else {
            Logger.getInstance().info(this, "systemd not found");
        }
        return properties;
    }

    private static void uninstallOnLinux(String unitFile, String executable) {
        if (unitFile != null && !unitFile.isEmpty()) {
            HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> {
                String content;
                File file = new File(unitFile);
                if (file.isFile() && (content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8)).contains(executable)) {
                    InstallServiceAction.doUninstallSystemd(true, new File(executable).getName(), file);
                }
            });
        }
    }

    @NotNull
    private static String getMacDomain() {
        return "gui/" + MacNativeUtil.getuid();
    }

    private static void uninstallOnMac(String identifier, String domain) {
        if (identifier != null && domain != null) {
            Logger.getInstance().info(null, "Removing " + identifier + " from domain " + domain);
            HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> {
                AddStartupItemAction.bootoutOnMac(domain, identifier, 30000, false);
                FileInstaller.getInstance().deleteFile(AddStartupItemAction.getPlistFile(identifier));
            });
        }
    }

    private static void bootoutOnMac(String domain, String identifier, int waitMillis, boolean stopOnly) {
        LaunchDescriptor launchctlDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true);
        long startNanos = System.nanoTime();
        long stopTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(waitMillis);
        while (LaunchHelper.launchApplicationAndCheck(launchctlDescriptor.arguments("kill", "SIGTERM", domain + "/" + identifier)) && System.nanoTime() - startNanos < stopTimeoutNanos) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!stopOnly) {
            LaunchHelper.launchApplicationAndCheck(launchctlDescriptor.arguments("bootout", domain + "/" + identifier));
        }
    }

    @Override
    public void runBeforeProcessCheck(Context context) {
        if (InstallerUtil.isMacOS()) {
            String identifier = this.getPersistentProperties().getProperty(PROPNAME_MACOS_IDENTIFIER);
            String domain = this.getPersistentProperties().getProperty(PROPNAME_MACOS_DOMAIN);
            if (identifier != null && domain != null) {
                HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, unelevatedContext -> AddStartupItemAction.bootoutOnMac(domain, identifier, 30000, true));
            }
        }
    }

    @Override
    public void rollback(InstallerContext context) {
        if (InstallerUtil.isMacOS()) {
            AddStartupItemAction.uninstallOnMac(this.getPersistentProperties().getProperty(PROPNAME_MACOS_IDENTIFIER), this.getPersistentProperties().getProperty(PROPNAME_MACOS_DOMAIN));
        } else if (!InstallerUtil.isWindows()) {
            AddStartupItemAction.uninstallOnLinux(this.getPersistentProperties().getProperty(PROPNAME_UNIT_FILE), this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            if (this.getPersistentProperties().size() == 1) {
                AddStartupItemAction.checkLegacyScriptAccessWithReset();
                AddStartupItemAction.deleteLegacyLoginItem(this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
            } else {
                AddStartupItemAction.uninstallOnMac(this.getPersistentProperties().getProperty(PROPNAME_MACOS_IDENTIFIER), this.getPersistentProperties().getProperty(PROPNAME_MACOS_DOMAIN));
            }
        } else if (!InstallerUtil.isWindows()) {
            AddStartupItemAction.uninstallOnLinux(this.getPersistentProperties().getProperty(PROPNAME_UNIT_FILE), this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
        }
        return true;
    }

    public boolean isHide() {
        return this.replaceWithTextOverride("hide", this.hide);
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String getName() {
        return AddStartupItemAction.replaceVariables(AddStartupItemAction.replaceVariables(this.name, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getExecutable() {
        return this.replaceWithTextOverride(PROPNAME_EXECUTABLE, AddStartupItemAction.replaceVariables(this.executable), File.class);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public String[] getArguments() {
        return this.replaceWithTextOverride("arguments", AddStartupItemAction.replaceVariables(this.arguments), String[].class);
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean isAllUsers() {
        return this.replaceWithTextOverride("allUsers", this.allUsers);
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }

    public String getMacosIdentifier() {
        return AddStartupItemAction.replaceVariables(AddStartupItemAction.replaceVariables(this.macosIdentifier));
    }

    public void setMacosIdentifier(String macosIdentifier) {
        this.macosIdentifier = macosIdentifier;
    }

    public boolean isStartImmediately() {
        return this.replaceWithTextOverride("startImmediately", this.startImmediately);
    }

    public void setStartImmediately(boolean startImmediately) {
        this.startImmediately = startImmediately;
    }

    public boolean isRequireGraphicalSession() {
        return this.replaceWithTextOverride("requireGraphicalSession", this.requireGraphicalSession);
    }

    public void setRequireGraphicalSession(boolean requireGraphicalSession) {
        this.requireGraphicalSession = requireGraphicalSession;
    }

    private static boolean deleteLegacyLoginItem(String executable) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> {
            if (executable != null) {
                File destinationFile = new File(executable);
                String name = destinationFile.getName();
                if (name.endsWith(".app")) {
                    name = name.substring(0, name.length() - 4);
                }
                boolean success = AppleScriptHelper.executeScript("tell app \"System Events\" to delete login item \"" + name + "\"", false);
                Logger.getInstance().info(null, "Deleting legacy login item " + name + ": " + success);
                return success;
            }
            return false;
        });
    }

    private static boolean removeLegacyLoginItem(InstallerContext context, final File finalDestinationFile) throws IOException {
        UninstallFilesAction.AutoUninstallProcessor autoUninstallProcessor = new UninstallFilesAction.AutoUninstallProcessor(){
            private final Set<String> removedItems = new HashSet<String>();
            boolean removedLoginItemInFile = false;

            @Override
            public boolean handle(AutoUninstallAction autoUninstallAction) throws UserCanceledException {
                if (autoUninstallAction instanceof AddStartupItemAction && autoUninstallAction.getPersistentProperties().size() == 1 && autoUninstallAction.getPersistentProperties().containsKey(AddStartupItemAction.PROPNAME_EXECUTABLE)) {
                    String previousExecutable = autoUninstallAction.getPersistentProperties().getProperty(AddStartupItemAction.PROPNAME_EXECUTABLE);
                    try {
                        File previousFile = new File(previousExecutable);
                        if (previousFile.getCanonicalFile().equals(finalDestinationFile.getCanonicalFile())) {
                            if (this.removedItems.isEmpty() && !AddStartupItemAction.checkLegacyScriptAccessWithReset()) {
                                throw new UserCanceledException();
                            }
                            String itemPath = previousFile.getAbsolutePath();
                            if (this.removedItems.add(itemPath)) {
                                AddStartupItemAction.deleteLegacyLoginItem(itemPath);
                                this.removedLoginItemInFile = true;
                            }
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance().log(e);
                    }
                }
                return false;
            }

            @Override
            public boolean shouldWriteRetained(List<AutoUninstallAction> retainedActions) {
                try {
                    boolean bl = this.removedLoginItemInFile;
                    return bl;
                }
                finally {
                    this.removedLoginItemInFile = false;
                }
            }
        };
        if (!UninstallFilesAction.iterateAutoUninstallActions(context, autoUninstallProcessor)) {
            Logger.getInstance().error(null, "could not remove previous login item because user did not give access to \"System Events\"");
            return false;
        }
        return true;
    }

    private static boolean checkLegacyScriptAccessWithReset() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> AppleScriptHelper.executeScript("tell application \"System Events\" to get the name of every login item", true));
    }

    private static Properties addOnMac(String identifier, File destinationFile, String[] arguments, boolean hide, boolean startImmediately) {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> AddStartupItemAction.addOnMacImpl(context, identifier, destinationFile, arguments, hide, startImmediately));
    }

    @Nullable
    private static Properties addOnMacImpl(Context context, String identifier, File destinationFile, String[] arguments, boolean hide, boolean startImmediately) {
        try {
            boolean hasArgs;
            Properties newProperties = new Properties();
            if (identifier == null || identifier.trim().isEmpty()) {
                identifier = "com.install4j." + context.getApplicationId() + "." + destinationFile.getName();
                Logger.getInstance().info(null, "Using fallback identifier: " + identifier);
            }
            String additionalPlistContent = "";
            ArrayList<String> command = new ArrayList<String>();
            boolean bl = hasArgs = arguments != null && arguments.length > 0;
            if (destinationFile.isDirectory()) {
                if (AddStartupItemAction.isInstall4jMacGuiLauncher(context, destinationFile)) {
                    command.add(MacLauncher.getMacBundleExecutableFile(destinationFile).getAbsolutePath());
                    command.add(hide ? "__i4j_workspace_open_hidden" : "__i4j_workspace_open");
                } else {
                    command.add("/usr/bin/open");
                    if (hide) {
                        command.add("-j");
                    }
                    command.add("-W");
                    command.add(destinationFile.getAbsolutePath());
                    if (hasArgs) {
                        command.add("--args");
                    }
                }
            } else {
                command.add(destinationFile.getAbsolutePath());
            }
            if (hasArgs) {
                command.addAll(Arrays.asList(arguments));
            }
            File plistFile = AddStartupItemAction.getPlistFile(identifier);
            plistFile.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(plistFile), StandardCharsets.UTF_8));){
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n    <key>Label</key>\n    <string>" + PlistHelper.quoteCharacters(identifier) + "</string>\n    <key>LimitLoadToSessionType</key>\n    <string>Aqua</string>\n    <key>ProgramArguments</key>\n    <array>");
                for (String arg : command) {
                    pw.println("        <string>" + PlistHelper.quoteCharacters(arg) + "</string>");
                }
                pw.println("    </array>\n    <key>KeepAlive</key>\n    <false/>\n    <key>RunAtLoad</key>\n    <true/>\n" + additionalPlistContent + "</dict>\n</plist>");
            }
            UnixFileSystem.setMode("644", plistFile);
            String domain = AddStartupItemAction.getMacDomain();
            if (startImmediately) {
                AddStartupItemAction.bootoutOnMac(domain, identifier, 30000, false);
                LaunchDescriptor launchctlDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true);
                if (!LaunchHelper.launchApplicationAndCheck(launchctlDescriptor.arguments("bootstrap", domain, AddStartupItemAction.getPlistFile(identifier).getAbsolutePath()))) {
                    Logger.getInstance().error(null, "Could not bootstrap launch agent " + identifier + " in domain " + domain);
                }
            }
            newProperties.setProperty(PROPNAME_EXECUTABLE, destinationFile.getAbsolutePath());
            newProperties.setProperty(PROPNAME_MACOS_TYPE, "LaunchAgent");
            newProperties.setProperty(PROPNAME_MACOS_IDENTIFIER, identifier);
            newProperties.setProperty(PROPNAME_MACOS_DOMAIN, domain);
            return newProperties;
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
            return null;
        }
    }

    private static boolean isInstall4jMacGuiLauncher(Context context, File destinationFile) throws IOException {
        File singleBundleDir = MacLauncher.getSingleBundleDirectory();
        if (singleBundleDir != null && Objects.equals(singleBundleDir.getCanonicalPath(), destinationFile.getCanonicalPath())) {
            return true;
        }
        return InstallerConfig.getCurrentInstance().getLaunchers().stream().anyMatch(launcherConfig -> {
            try {
                return (launcherConfig.getType() == LauncherType.GUI || launcherConfig.getType() == LauncherType.INSTALLER_APPLICATION) && Objects.equals(destinationFile.getCanonicalPath(), context.getDestinationFile(launcherConfig.getFile()).getCanonicalPath());
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @NotNull
    private static File getPlistFile(String identifier) {
        return new File(System.getProperty("user.home"), "Library/LaunchAgents/" + identifier + ".plist");
    }
}

