package com.install4j.api.beans;

/**
 * Implemented by beans that contain visual components.
 *
 * @see com.install4j.api.screens.Screen
 * @see com.install4j.api.styles.Style
 * @author ej-technologies GmbH
 */
public interface VisualContainerBean extends Bean {

    /**
     * Returns whether the visual component wants to grow in the vertical direction. If not,
     * the visual component will be aligned at the top of the available space and be sized at its
     * preferred vertical size. If, for example, you have a list in your layout that should
     * use as much vertical space as possible, you should return {@code true} here. In that case
     * you would also want to return {@code true} in {@code isFillHorizontal}. If all
     * your components are fixed-size components, return {@code false}.
     * <p>In console or unattended mode, this method is never called.</p>
     *
     * @return {@code true} or {@code false}.
     * @see #isFillHorizontal()
     */
    boolean isFillVertical();

    /**
     * Returns whether the visual component wants to grow in the horizontal direction. If not,
     * the visual component will be aligned at the left of the available space and be sized at its
     * preferred horizontal size. If, for example, you have text fields in your layout that should
     * use as much horizontal space as possible, you should return {@code true} here. If all your components
     * are fixed-size components, return {@code false}.
     * <p>In console or unattended mode, this method is never called.</p>
     *
     * @return {@code true} or {@code false}.
     * @see #isFillVertical()
     */
    boolean isFillHorizontal();

    /**
     * Returns the position where the visual component should be anchored.
     * The effect of this value is linked to the return values of {@link #isFillHorizontal()} and {@link #isFillVertical()}:
     * <ul>
     * <li>
     * If both {@link #isFillHorizontal()} and {@link #isFillVertical()} return false, all anchor values
     * have distinct effects.
     * </li>
     * <li>
     * If only {@link #isFillHorizontal()} returns true, <em>only the vertical part</em> of the anchor is used.
     * </li>
     * <li>
     * If only {@link #isFillVertical()} returns true, <em>only the horizontal part</em> of the anchor is used.
     * </li>
     * <li>
     * If both {@link #isFillHorizontal()} and {@link #isFillVertical()} return true, this value has <em>no effect</em>.
     * </li>
     * </ul>
     *
     * @return the anchor
     */
    Anchor getAnchor();

}
