package com.install4j.api.beans;

/**
 * Variable replacement mode for string properties that are used in regular expressions.
 * The enumerated class is used as a parameter to {@link AbstractBean#replaceVariables(String, ReplacementMode)}.
 */
public enum ReplacementMode {

    /**
     * Normal replacement like in {@link AbstractBean#replaceVariables(String)}.
     */
    PLAIN,

    /**
     * Only i18n variables like {@code ${i18n:myKey}} will be replaced.
     */
    I18N_ONLY,

    /**
     * The property is used as a regular expression. All special characters are quoted.
     */
    REGEXP_MATCH,

    /**
     * The property is used as a replacement part of a regular expression. Backslashes and dollar signs are quoted.
     */
    REGEXP_REPLACEMENT,

    /**
     * The property is used while replacing text directly in a Java properties file.
     * See the Javadoc for java.util.Properties for more information on the encoding of
     * a Java properties file. 
     */
    PROPERTIES_FILE

}
