package com.install4j.api.beans;

/**
 * Indicates the action that should be taken after an error has occurred.
 *
 * @author ej-technologies GmbH
 */
public enum ErrorHandlingMode {
    /**
     * Retry the operation that just failed.
     */
    RETRY("Retry"),
    /**
     * Ignore the error and continue.
     */
    IGNORE("Ignore"),
    /**
     * Cancel the current operation.
     */
    CANCEL("Cancel");

    private final String verbose;

    ErrorHandlingMode(String verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return verbose;
    }
}
