package com.install4j.api.beaninfo;


/**
 * Enumeration class for all possible file content types for file property descriptors.
 * @see FilePropertyDescriptor#setFileContentType(FileContentType)
 */
public enum FileContentType {

    /**
     * The file has a content type that cannot be edited in the editors that associated with the
     * other file content types in this enumeration class. This is the default state for
     * {@link FilePropertyDescriptor}s.
     */
    OTHER("Other"),

    /**
     * The file contains text encoded in UTF-8 format. The install4j IDE will provide a text editor that
     * allows the user to edit the file. Also, the user can create text files from within the IDE.
     */
    TEXT("Text"),

    /**
     * The file contains HTML encoded in UTF-8 format. The install4j IDE will provide an HTML editor that
     * allows the user to edit the file. Also, the user can create HTML files from within the IDE.
     */
    HTML("HTML");

    private final String verbose;

    FileContentType(String verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return verbose;
    }
}
