package com.install4j.api.beaninfo;

/**
 * Enumeration class for all possible failure strategies of actions.
 *
 * @see ActionBeanInfo#setDefaultFailureStrategy(FailureStrategy)
 */
public enum FailureStrategy {

    /**
     * Continue after a failure.
     */
    CONTINUE(com.install4j.runtime.beans.actions.FailureStrategy.CONTINUE.getIntValue()),

    /**
     * Quit after a failure.
     */
    QUIT(com.install4j.runtime.beans.actions.FailureStrategy.QUIT.getIntValue()),

    /**
     * Ask the user what to do when an action fails. By default, The user can retry the action, ignore the error or
     * quit the installer application. The enabled questions can be selected in the IDE, the questions that are
     * selected by default are configured with {@link ActionBeanInfo#setAskUserFailureDefaults(AskUserFailureDefaults)}.
     */
    ASK_USER(com.install4j.runtime.beans.actions.FailureStrategy.ASK_USER.getIntValue()),

    /**
     * Ask the user whether to continue, to retry or to quit.
     *
     * @deprecated use {@link #ASK_USER} instead, the questions that are selected by default are now set individually
     * with {@link ActionBeanInfo#setAskUserFailureDefaults(AskUserFailureDefaults)}.
     */
    @Deprecated
    ASK_USER_RETRY(-1),

    /**
     * No further actions will be executed, and the previous screen will be displayed again.
     * If the action is contained in the startup node, the first screen will be displayed.
     */
    RETURN_TO_SCREEN(com.install4j.runtime.beans.actions.FailureStrategy.RETURN_TO_SCREEN.getIntValue());

    private final int id;

    FailureStrategy(int id) {
        this.id = id;
    }

    /**
     * Convert to an int value.
     *
     * @return the int value
     */
    public int getId() {
        return id;
    }
}
