package com.install4j.api.beaninfo;

import com.install4j.api.beans.Bean;

/**
 * Interface for the {@link Install4JBeanInfo#ATTRIBUTE_BEAN_VALIDATOR} value of a bean descriptor.
 * With a bean validator, you can check at design-time if the values of the bean properties are valid
 * and notify the user if this is not the case.
 * <p>The {@link Install4JBeanInfo} class offers a number of convenience methods to help bean validators to
 * quickly check common conditions. It is most convenient if you make the bean info implement the
 * {@code BeanValidator} interface itself, in that case the convenience methods are directly accessible.
 * @see Install4JBeanInfo#checkNotEmpty(String, Bean)
 * @see Install4JBeanInfo#checkNotEmpty(String, String, Bean)
 * @see  Install4JBeanInfo#isEmpty(String, Bean)
 * @see Install4JBeanInfo#findPropertyDescriptor(String)
 * @see Install4JBeanInfo#getPropertyValue(java.beans.PropertyDescriptor, Bean)
 */
public interface BeanValidator {
    /**
     * Called by the install4j GUI at design-time to check the validity of the bean properties.
     * This method is called repeatedly when the user switches between different beans as well
     * as by the compiler.
     * @param bean the bean that should be validated
     * @throws BeanValidationException Throw this exception if the bean properties are not valid
     */
    void validateBean(Bean bean) throws BeanValidationException;
}
