package com.install4j.api.beaninfo;

/**
 * Exception for notifying the user that a property value of a bean is not valid.
 * Throw this exception in implementations of {@link BeanValidator#validateBean(com.install4j.api.beans.Bean)}.
 * The user will be notified with a message constructed from the supplied information.
 */
public class BeanValidationException extends Exception {

    private String propertyName;
    private String customizerTabName;

    /**
     * Constructor with an error message.
     * @param errorMessage the error message
     */
    public BeanValidationException(String errorMessage) {
        this(errorMessage, null);
    }

    /**
     * Constructor with an error message and a property name.
     * The specified property will be selected in the install4j GUI.
     * @param errorMessage the error message
     * @param propertyName the name of the invalid property
     */
    public BeanValidationException(String errorMessage, String propertyName) {
        super(errorMessage);
        this.propertyName = propertyName;
    }

    /**
     * Get the name of the invalid property, or {@code null} if no property name was specified in the constructor.
     * @return the property name
     */
    public String getPropertyName() {
        return propertyName;
    }

    /**
     * Set the name of the customizer tab if the error message applies to a customizer. This is either the
     * {@code name} property of the {@code javax.swing.JComponent} or, if the customizer is a
     * {@code javax.swing.JTabbedPane}, the name of the tab.
     * @param customizerTabName the name
     * @see Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class, Class)
     */
    public void setCustomizerTabName(String customizerTabName) {
        this.customizerTabName = customizerTabName;
    }

    /**
     * Get the name of the customizer tab that was set with {@code setCustomizerTabName}.
     * @return the name
     * @see #setCustomizerTabName(String)
     */
    public String getCustomizerTabName() {
        return customizerTabName;
    }
}
