/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools;

import com.install4j.buildtools.BaseTaskConfig;
import com.install4j.buildtools.InvalidConfigException;
import com.install4j.buildtools.ModuleSet;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateBundleTaskConfig
extends BaseTaskConfig {
    private final File javaHome;
    private final File outputDirectory;
    private final String version;
    private final boolean unpacked;
    private final String id;
    private final String jdkRelease;
    private final String jdkProviderId;
    private final List<String> addModules;
    private final ModuleSet addModuleSet;
    private final List<File> jmodFiles;
    private final List<File> jmodDirs;

    public CreateBundleTaskConfig(@Nullable File installDir, @Nullable File autoProvisioningCacheDir, @NotNull List<String> vmParameters, File javaHome, File outputDirectory, String version, boolean unpacked, String id, String jdkRelease, String jdkProviderId, List<String> addModules, ModuleSet addModuleSet, List<File> jmodFiles, List<File> jmodDirs) {
        super(installDir, autoProvisioningCacheDir, vmParameters);
        this.javaHome = javaHome;
        this.outputDirectory = outputDirectory;
        this.version = version;
        this.unpacked = unpacked;
        this.id = id;
        this.jdkRelease = jdkRelease;
        this.jdkProviderId = jdkProviderId;
        this.addModules = addModules;
        this.addModuleSet = addModuleSet;
        this.jmodFiles = jmodFiles;
        this.jmodDirs = jmodDirs;
    }

    @Override
    @NotNull
    protected String getExecutableName() {
        return "createbundle";
    }

    @Override
    protected void buildCommandLine(List<String> commandLine2) throws InvalidConfigException {
        super.buildCommandLine(commandLine2);
        if (this.javaHome == null) {
            throw new InvalidConfigException("property \"javaHome\" must be set");
        }
        if (this.outputDirectory != null) {
            commandLine2.add("-o");
            commandLine2.add(this.outputDirectory.getPath());
        }
        if (this.version != null) {
            commandLine2.add("-v");
            commandLine2.add(this.version);
        }
        if (this.id != null) {
            commandLine2.add("-i");
            commandLine2.add(this.id);
        }
        if (this.unpacked) {
            commandLine2.add("-u");
        }
        if (this.jdkRelease != null) {
            commandLine2.add("-r");
            commandLine2.add(this.jdkRelease);
        }
        if (this.jdkProviderId != null) {
            commandLine2.add("-p");
            commandLine2.add(this.jdkProviderId);
        }
        if (this.addModules != null && !this.addModules.isEmpty()) {
            commandLine2.add("-m");
            StringBuilder buffer = new StringBuilder();
            for (String line : this.addModules) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(line);
            }
            commandLine2.add(buffer.toString());
        }
        if (this.addModuleSet != null) {
            commandLine2.add("-s");
            commandLine2.add(this.addModuleSet.getOptionValue());
        }
        if (this.jmodFiles != null) {
            for (File jmodFile : this.jmodFiles) {
                commandLine2.add("-j");
                commandLine2.add(jmodFile.getPath());
            }
        }
        if (this.jmodDirs != null) {
            for (File jmodDir : this.jmodDirs) {
                commandLine2.add("-d");
                commandLine2.add(jmodDir.getPath());
            }
        }
        commandLine2.add(this.javaHome.getPath());
    }

    @Override
    protected void addVmParameters(List<String> commandLine2) {
        this.addVmParameter("-Dinstall4j.mergeStderr=true", commandLine2);
        super.addVmParameters(commandLine2);
    }
}

