/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class ComponentFolderNode
extends ComponentNode {
    private boolean allSelected = false;
    private boolean changeable = true;
    private Set<ComponentNode> hiddenNodes = new HashSet<ComponentNode>();

    public ComponentFolderNode(ComponentFolderConfig config, ComponentTreeModel model) {
        super(config, model);
    }

    public ComponentFolderConfig getComponentFolderConfig() {
        return (ComponentFolderConfig)this.getComponentNodeConfig();
    }

    public boolean isAllSelected() {
        return this.allSelected;
    }

    public void checkState() {
        boolean changed;
        ComponentFolderConfig config = this.getComponentFolderConfig();
        if (config == null || config.isBlockStateChanges()) {
            return;
        }
        boolean hasSelected = false;
        boolean allSelected = true;
        boolean changeable = this.isChangeable();
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            ComponentNode childNode = (ComponentNode)en.nextElement();
            if (childNode.isSelected()) {
                hasSelected = true;
                if (!(childNode instanceof ComponentFolderNode) || ((ComponentFolderNode)childNode).isAllSelected()) continue;
                allSelected = false;
                continue;
            }
            allSelected = false;
        }
        boolean bl = changed = config.isSelected() != hasSelected || this.allSelected != allSelected || this.changeable != changeable;
        if (changed) {
            this.allSelected = allSelected;
            this.changeable = changeable;
            config.setSelected(hasSelected);
            this.changed();
        }
        ((ComponentFolderNode)this.getParent()).checkState();
    }

    @Override
    protected boolean isChangeable() {
        boolean defaultReturn = true;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            ComponentNode childNode = (ComponentNode)en.nextElement();
            if (childNode.isChangeable()) {
                return true;
            }
            defaultReturn = false;
        }
        return defaultReturn;
    }

    public void hide(ComponentNode componentNode) {
        if (!this.hiddenNodes.contains(componentNode)) {
            this.getModel().removeNodeFromParent(componentNode);
            componentNode.setParent(this);
            this.hiddenNodes.add(componentNode);
        }
    }

    public void show(ComponentNode componentNode) {
        if (this.hiddenNodes.remove(componentNode)) {
            componentNode.setParent(null);
            this.getModel().insertNodeInto(componentNode, this, this.getChildCount());
        }
    }
}

