/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.beans.formcomponents.WidgetStyleHandlerImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.CustomPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class InstallationScopeChooserComponent
extends SystemFormComponent {
    public static final String FORM_VARIABLE_INSTALLATION_SCOPE_MESSAGE = "installationScopeMessage";
    private ScriptProperty selectionScript;
    private JRadioButton rdoUserWritable;
    private JRadioButton rdoAllUsers;
    private ButtonGroup bgrInstallationScope;
    private boolean installationScopeMessageSet;

    public ScriptProperty getSelectionScript() {
        return this.replaceWithTextOverride("selectionScript", this.selectionScript, ScriptProperty.class);
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public JComponent createCenterComponent() {
        CustomPanel panel = new CustomPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.anchor = 23;
        gc.fill = 2;
        gc.weightx = 1.0;
        ItemListener listener = e -> {
            if (e.getStateChange() == 1) {
                this.executeSelectionScript();
            }
        };
        WidgetStyleHandlerImpl widgetStyleHandler = this.getWidgetStyleHandler();
        this.rdoUserWritable = widgetStyleHandler.applyWidgetStyle(new JRadioButton(this.getContext().getMessage(".RadioUserWritableInstallation")));
        this.rdoUserWritable.setOpaque(false);
        this.rdoAllUsers = widgetStyleHandler.applyWidgetStyle(new JRadioButton(this.getContext().getMessage(".RadioAllUsersInstallationScope")));
        this.rdoAllUsers.setOpaque(false);
        this.rdoAllUsers.addItemListener(listener);
        this.updateSelection();
        this.rdoUserWritable.addItemListener(listener);
        this.bgrInstallationScope = new ButtonGroup();
        this.bgrInstallationScope.add(this.rdoUserWritable);
        this.bgrInstallationScope.add(this.rdoAllUsers);
        gc.fill = 0;
        gc.insets.top = 5;
        panel.add((Component)this.rdoUserWritable, gc);
        gc.insets.top = 0;
        ++gc.gridy;
        panel.add((Component)this.rdoAllUsers, gc);
        ++gc.gridy;
        return panel;
    }

    private void updateSelection() {
        if (this.getContext().getBooleanVariable("sys.installForAllUsers")) {
            this.rdoAllUsers.setSelected(true);
        } else {
            this.rdoUserWritable.setSelected(true);
        }
    }

    public boolean isInstallForAllUsers() {
        return this.rdoAllUsers.isSelected();
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        this.updateSelection();
        Context context = this.getContext();
        if (!this.installationScopeMessageSet) {
            this.installationScopeMessageSet = true;
            this.getFormEnvironment().setFormVariable(FORM_VARIABLE_INSTALLATION_SCOPE_MESSAGE, Messages.format(InstallationScopeChooserComponent.replaceVariables(context.getMessage(this.isInstallForAllUsers() ? ".InstallationScopeMessageElevatedDefault" : ".InstallationScopeMessage")), context.getApplicationName()));
        }
    }

    @Override
    public void formActivated() {
        super.formActivated();
        if (this.isVisible()) {
            this.executeSelectionScript();
        }
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.getSelectionScript(), this, this.getFormEnvironment(), this.rdoAllUsers.isSelected());
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    @Override
    public boolean checkCompleted() {
        if (this.getContext().isGui()) {
            this.getContext().setVariable("sys.installForAllUsers", this.isInstallForAllUsers());
        }
        return super.checkCompleted();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        Context context = this.getContext();
        int result = console.askOption(context.getMessage(".InstallationScopeConsole", this.getContext().getInstallationDirectory().getPath()), new String[]{context.getMessage(".RadioUserWritableInstallation"), context.getMessage(".RadioAllUsersInstallationScope")}, null, this.getContext().getBooleanVariable("sys.installForAllUsers") ? 1 : 0, false, true);
        context.setVariable("sys.installForAllUsers", result == 1);
        return true;
    }
}

