/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AbstractListComponent;
import com.install4j.runtime.beans.widgets.ComboBoxWidgetStyle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class DropdownListComponent
extends AbstractListComponent
implements ActionListener {
    private JComboBox<String> comboBox;
    private String widgetStyleId = "";
    private ComboBoxWidgetStyle widgetStyle = new ComboBoxWidgetStyle();

    public String getWidgetStyleId() {
        return DropdownListComponent.replaceVariables(this.widgetStyleId);
    }

    public void setWidgetStyleId(String widgetStyleId) {
        this.widgetStyleId = widgetStyleId;
    }

    public ComboBoxWidgetStyle getWidgetStyle() {
        return this.replaceWithTextOverride("widgetStyle", this.widgetStyle, ComboBoxWidgetStyle.class);
    }

    public void setWidgetStyle(ComboBoxWidgetStyle widgetStyle) {
        this.widgetStyle = widgetStyle;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.comboBox != null && formEnvironment != null) {
            this.comboBox.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.comboBox = new JComboBox();
        this.comboBox.setAlignmentX(0.0f);
        return this.comboBox;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.comboBox.removeActionListener(this);
        this.comboBox.setModel(new DefaultComboBoxModel<String>(this.getListEntries()));
        this.applyComboBoxProperties(this.comboBox);
        this.comboBox.addActionListener(this);
        this.selectionChanged();
        this.adjustMinimumSize(this.comboBox, this.comboBox);
    }

    protected void applyComboBoxProperties(JComboBox<String> comboBox) {
        int initiallySelectedIndex = (Integer)this.getInitValue(this.getInitiallySelectedIndex(), this.getVariableName(), Integer.class);
        if (initiallySelectedIndex < this.getListEntries().length) {
            comboBox.setSelectedIndex(initiallySelectedIndex);
        }
        this.getWidgetStyleHandler().applyWidgetStyle(comboBox, this.getWidgetStyleId(), this.getWidgetStyle());
    }

    protected JComboBox<String> getComboBox() {
        return this.comboBox;
    }

    @Override
    public Object getConfigurationObject() {
        return this.comboBox;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JComboBox.class;
    }

    @Override
    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), this.comboBox.getSelectedIndex());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    protected boolean getInitialFillHorizontal() {
        return false;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String[] descriptions = new String[this.comboBox.getItemCount()];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = this.comboBox.getItemAt(i);
        }
        int newValue = console.askOption(this.getConsoleLabelText(false), descriptions, null, this.comboBox.getSelectedIndex(), true, true);
        this.comboBox.setSelectedIndex(newValue);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboBox) {
            this.selectionChanged();
        }
    }

    private void selectionChanged() {
        this.selectionChanged(this.comboBox.getSelectedItem(), this.comboBox.getSelectedIndex());
    }
}

