/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.runtime.beans.formcomponents.TextComponent;
import com.install4j.runtime.util.MinimumSizeTextArea;
import com.install4j.runtime.util.TextAreaScrollPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public abstract class AbstractTextAreaComponent
extends TextComponent {
    private int columns = 0;
    private int rows = 3;
    private boolean fillVertical = false;
    private boolean useLabelFont = false;

    public int getColumns() {
        return this.replaceWithTextOverride("columns", this.columns);
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.replaceWithTextOverride("rows", this.rows);
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    public boolean isUseLabelFont() {
        return this.replaceWithTextOverride("useLabelFont", this.useLabelFont);
    }

    public void setUseLabelFont(boolean useLabelFont) {
        this.useLabelFont = useLabelFont;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    @Override
    public JComponent createCenterComponent() {
        return new TextAreaScrollPane(super.createCenterComponent(), this.getColumns() > 0);
    }

    @Override
    protected JTextComponent createTextComponent() {
        int rows;
        MinimumSizeTextArea textArea = new MinimumSizeTextArea();
        int columns = this.getColumns();
        if (columns > 0) {
            textArea.setColumns(columns);
        }
        if ((rows = this.getRows()) > 0) {
            textArea.setRows(rows);
        }
        this.getWidgetStyleHandler().applyWidgetStyle(textArea, this.getWidgetStyleId(), this.getWidgetStyle());
        return textArea;
    }

    @Override
    protected void applyTextComponentProperties(JTextComponent textComponent) {
        super.applyTextComponentProperties(textComponent);
        if (this.isUseLabelFont()) {
            textComponent.setFont(UIManager.getFont("Label.font"));
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return this.getColumns() == 0;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JTextArea.class;
    }

    @Override
    protected boolean isLeadingLabelTopAligned() {
        return true;
    }
}

