/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.beans.actions.files.CreateSymlinkAction;
import com.install4j.runtime.beans.actions.files.SymlinkFailureMode;
import com.install4j.runtime.beans.actions.files.SymlinkMode;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class CopyFileAction
extends AbstractRecursiveFileAction {
    private File destinationFile;
    private ArchiveFileOperationRoot destinationRoot = ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private String mode = "644";
    private String directoryMode = "755";
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delay = false;
    private boolean triggerReboot = true;
    private SymlinkMode symlinkMode = SymlinkMode.COPY_CONTENT;
    private SymlinkFailureMode symlinkFailureMode = SymlinkFailureMode.FAIL;
    private transient boolean toSingleFile;

    public boolean isDelay() {
        return this.replaceWithTextOverride("delay", this.delay);
    }

    public void setDelay(boolean delay) {
        this.delay = delay;
    }

    public boolean isTriggerReboot() {
        return this.replaceWithTextOverride("triggerReboot", this.triggerReboot);
    }

    public void setTriggerReboot(boolean triggerReboot) {
        this.triggerReboot = triggerReboot;
    }

    public String getDirectoryMode() {
        return CopyFileAction.replaceVariables(this.directoryMode);
    }

    public void setDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
    }

    public File getDestinationFile() {
        return this.replaceWithTextOverride("destinationFile", CopyFileAction.replaceVariables(this.destinationFile), File.class);
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public ArchiveFileOperationRoot getDestinationRoot() {
        return this.replaceWithTextOverride("destinationRoot", this.destinationRoot, ArchiveFileOperationRoot.class);
    }

    public void setDestinationRoot(ArchiveFileOperationRoot destinationRoot) {
        this.destinationRoot = destinationRoot;
    }

    public OverwriteMode getOverwriteMode() {
        return this.replaceWithTextOverride("overwriteMode", this.overwriteMode, OverwriteMode.class);
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public UninstallMode getUninstallMode() {
        return this.replaceWithTextOverride("uninstallMode", this.uninstallMode, UninstallMode.class);
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    public String getMode() {
        return CopyFileAction.replaceVariables(this.mode);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isShared() {
        return this.replaceWithTextOverride("shared", this.shared);
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public SymlinkMode getSymlinkMode() {
        return this.replaceWithTextOverride("symlinkMode", this.symlinkMode, SymlinkMode.class);
    }

    public void setSymlinkMode(SymlinkMode symlinkMode) {
        this.symlinkMode = symlinkMode;
    }

    public SymlinkFailureMode getSymlinkFailureMode() {
        return this.replaceWithTextOverride("symlinkFailureMode", this.symlinkFailureMode, SymlinkFailureMode.class);
    }

    public void setSymlinkFailureMode(SymlinkFailureMode symlinkFailureMode) {
        this.symlinkFailureMode = symlinkFailureMode;
    }

    @Override
    protected ArchiveFileOperationRoot getInitialFilesRoot() {
        return ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeForMultipleFilesAction(Context context, File[] files) throws UserCanceledException {
        File destinationFile = this.getUsedDestinationFile(context);
        this.toSingleFile = false;
        if (!destinationFile.isDirectory()) {
            if (files.length > 1) {
                Logger.getInstance().log(this, "Destination file " + destinationFile + " is not a directory and there are more than one source files", false);
                return false;
            }
            if (context.getDestinationFile(files[0]).isFile()) {
                this.toSingleFile = true;
            }
        }
        FileInstaller.getInstance().resetCurrentRebootRequired();
        try {
            boolean bl = super.executeForMultipleFilesAction(context, files);
            return bl;
        }
        finally {
            if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                context.triggerReboot(true);
            }
        }
    }

    private File getUsedDestinationFile(Context context) {
        return this.resolveRelativeFile(this.getDestinationFile(), this.getDestinationRoot(), context);
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        boolean symlink;
        FileInstaller fileInstaller = FileInstaller.getInstance();
        File destinationFile = this.getUsedDestinationFile(context);
        boolean bl = symlink = this.getSymlinkMode() != SymlinkMode.COPY_CONTENT && Files.isSymbolicLink(file.toPath());
        if (file.isDirectory() && !symlink) {
            File parentDirectory = this.getCanonicalFileNoError(new File(destinationFile, relativeSourceFile.getPath()));
            fileInstaller.createDirectory(parentDirectory, this.getUninstallMode());
            long time = file.lastModified();
            if (time > 0L) {
                parentDirectory.setLastModified(time);
            }
            if (!InstallerUtil.isWindows()) {
                UnixFileSystem.setMode(this.getDirectoryMode(), parentDirectory);
            }
        } else {
            Path symlinkTarget;
            File destFile;
            block22: {
                destFile = this.toSingleFile ? destinationFile : this.getCanonicalFileNoError(new File(destinationFile, relativeSourceFile.getPath()));
                Util.logInfo(null, this.getActionName() + " " + file + " to " + destFile);
                symlinkTarget = null;
                if (symlink) {
                    try {
                        symlinkTarget = Files.readSymbolicLink(file.toPath());
                        if (!symlinkTarget.isAbsolute() && this.getSymlinkMode() == SymlinkMode.ABSOLUTE) {
                            symlinkTarget = file.getParentFile().toPath().resolve(symlinkTarget).normalize();
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance().log(e);
                        if (this.getSymlinkFailureMode() == SymlinkFailureMode.FAIL) {
                            return false;
                        }
                        if (this.getSymlinkFailureMode() != SymlinkFailureMode.SKIP) break block22;
                        return true;
                    }
                }
            }
            if (this.isInOverriddenTargetDir(destFile)) {
                if (symlinkTarget != null) {
                    if (CreateSymlinkAction.createLink(symlinkTarget.toString(), destFile)) {
                        return true;
                    }
                    if (this.getSymlinkFailureMode() == SymlinkFailureMode.FAIL) {
                        return false;
                    }
                    if (this.getSymlinkFailureMode() == SymlinkFailureMode.SKIP) {
                        return true;
                    }
                }
                if (!FileUtil.copyFile(file, destFile, progressAdapter)) {
                    return false;
                }
                destFile.setLastModified(file.lastModified());
            } else {
                if (symlinkTarget != null) {
                    boolean existing = destFile.exists();
                    if (CreateSymlinkAction.createLink(symlinkTarget.toString(), destFile)) {
                        if (this.getUninstallMode() == UninstallMode.ALWAYS || this.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE || !existing && this.getUninstallMode() != UninstallMode.NEVER) {
                            FileInstaller.getInstance().registerUninstallFile(destFile, this.getUninstallMode());
                        }
                        return true;
                    }
                    if (this.getSymlinkFailureMode() == SymlinkFailureMode.FAIL) {
                        return false;
                    }
                    if (this.getSymlinkFailureMode() == SymlinkFailureMode.SKIP) {
                        return true;
                    }
                }
                if (!fileInstaller.install(file, destFile, new FileOptions(file.lastModified(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode()), progressAdapter)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean isAddTopLevelDirectoriesToRelativePath() {
        return false;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    private File getCanonicalFileNoError(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    protected String getActionName() {
        return "Copy";
    }
}

