/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime;

import com.exe4j.runtime.WinLauncher;
import com.exe4j.runtime.gui.RuntimeErrorFrame;
import com.exe4j.runtime.util.LazyFileOutputStream;
import com.exe4j.runtime.util.NullOutputStream;
import com.exe4j.runtime.util.ResourceHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class LauncherEngine {
    public static final String MODULE_HANDLER_CLASS_NAME = "com.exe4j.runtime.jpms.ModuleHandler";
    public static final String EMPTY_REDIRECTION_PLACEHOLDER = "0";
    private static Properties properties;
    public static final String DEV_NULL = "/dev/null";
    public static final String PROPNAME_MODULE_NAME = "exe4j.moduleName";
    public static final String PROPNAME_APP_DIR = "install4j.appDir";
    public static final String PROPNAME_EXE_DIR = "install4j.exeDir";
    public static final String PROPNAME_NO_REDIRECTION = "install4j.noRedir";
    public static final int EXE4J_MAGIC = -387705899;
    private static IntegrationChecker integrationChecker;

    public static void setIntegrationChecker(IntegrationChecker integrationChecker) {
        LauncherEngine.integrationChecker = integrationChecker;
    }

    public static void launch(String className, String[] args, String stdErrFile, String stdOutFile, boolean failOnMainMethodException, boolean guiApplication, ClassLoader classLoader) {
        File runtimeDir;
        if (Boolean.getBoolean(PROPNAME_NO_REDIRECTION)) {
            stdErrFile = "";
            stdOutFile = "";
        }
        stdErrFile = LauncherEngine.replaceRedirectionFile(stdErrFile);
        stdOutFile = LauncherEngine.replaceRedirectionFile(stdOutFile);
        String moduleName = System.getProperty(PROPNAME_MODULE_NAME);
        if (moduleName != null) {
            try {
                System.setProperty(PROPNAME_EXE_DIR, new File(moduleName).getParentFile().getCanonicalPath() + File.separator);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((!WinLauncher.isUsed() || WinLauncher.APP_MODE_INSTALL4J) && (runtimeDir = ResourceHelper.getRuntimeDir()) != null) {
            System.setProperty(PROPNAME_APP_DIR, runtimeDir.getParentFile().getAbsolutePath() + File.separator);
        }
        try {
            try {
                LauncherEngine.doRedirection(stdErrFile, stdOutFile);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (integrationChecker != null) {
                integrationChecker.checkIntegrations(args);
            }
            try {
                Class[] mainParamClasses = new Class[]{String[].class};
                Object[] mainParams = new Object[]{args};
                Class mainClass = className.startsWith("/") ? (Class)Class.forName(MODULE_HANDLER_CLASS_NAME).getMethod("findClass", String.class).invoke(null, className.substring(1)) : classLoader.loadClass(className);
                Method mainMethod = mainClass.getDeclaredMethod("main", mainParamClasses);
                mainMethod.setAccessible(true);
                mainMethod.invoke(null, mainParams);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                LauncherEngine.handleFailure(failOnMainMethodException, guiApplication, cause != null ? cause : e);
            }
            catch (Throwable t) {
                LauncherEngine.handleFailure(failOnMainMethodException, guiApplication, t);
            }
        }
        catch (Throwable t) {
            LauncherEngine.handleFailure(true, guiApplication, t);
        }
    }

    private static String replaceRedirectionFile(String fileName) {
        return LauncherEngine.replaceUserHome(LauncherEngine.replaceEmptyPlaceHolder(fileName));
    }

    private static String replaceEmptyPlaceHolder(String fileName) {
        if (EMPTY_REDIRECTION_PLACEHOLDER.equals(fileName)) {
            return "";
        }
        return fileName;
    }

    public static String replaceUserHome(String fileName) {
        if (fileName != null && fileName.startsWith("~")) {
            return System.getProperty("user.home") + fileName.substring(1);
        }
        return fileName;
    }

    public static String getProperty(int key) {
        return properties == null ? null : properties.getProperty(String.valueOf(key));
    }

    public static boolean getBooleanProperty(int key) {
        try {
            String stringValue = LauncherEngine.getProperty(key);
            if (stringValue == null || stringValue.isEmpty()) {
                return false;
            }
            return Integer.parseInt(stringValue) == 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getIntProperty(int key) {
        try {
            String stringValue = LauncherEngine.getProperty(key);
            if (stringValue == null || stringValue.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private LauncherEngine() {
    }

    public static void setProperties(Properties properties) {
        LauncherEngine.properties = properties;
    }

    private static void handleFailure(boolean failOnMainMethodException, boolean guiApplication, Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
        if (failOnMainMethodException) {
            try {
                if (!guiApplication || !RuntimeErrorFrame.Invoker.showIfNotHeadless(t)) {
                    System.exit(1);
                }
            }
            catch (Throwable ignored) {
                System.exit(1);
            }
        }
    }

    private static void doRedirection(String stdErrFile, String stdOutFile) throws FileNotFoundException {
        PrintStream out = null;
        if (stdOutFile.equals(DEV_NULL)) {
            System.setOut(new PrintStream(new NullOutputStream()));
        } else if (!stdOutFile.isEmpty() && LauncherEngine.checkRedirectionFile(stdOutFile)) {
            out = new PrintStream(new BufferedOutputStream(new LazyFileOutputStream(stdOutFile)), true);
            System.setOut(out);
        }
        if (stdErrFile.equals(DEV_NULL)) {
            System.setErr(new PrintStream(new NullOutputStream()));
        } else if (!stdErrFile.isEmpty() && LauncherEngine.checkRedirectionFile(stdErrFile)) {
            PrintStream err = stdErrFile.equalsIgnoreCase(stdOutFile) ? out : new PrintStream(new LazyFileOutputStream(stdErrFile), true);
            System.setErr(err);
        }
    }

    private static boolean checkRedirectionFile(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        File parentFile = file.getParentFile();
        parentFile.mkdirs();
        if (!parentFile.exists()) {
            throw new FileNotFoundException("log file directory '" + parentFile + "' doesn't exist.");
        }
        if (file.exists()) {
            return file.canWrite();
        }
        return parentFile.canWrite();
    }

    public static interface IntegrationChecker {
        public void checkIntegrations(String[] var1);
    }
}

