/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.services.AbstractControlServiceActionBeanInfo;
import com.install4j.runtime.beans.actions.services.InstallServiceAction;
import com.install4j.runtime.beans.actions.services.ServiceAccount;
import com.install4j.runtime.beans.common.CategoryUtil;

@BeanInfo
public class InstallServiceActionBeanInfo
extends AbstractControlServiceActionBeanInfo {
    public static final String NAME = "Install a service";
    private static final String PROPERTY_ACCOUNT_NAME_OR_SID = "accountNameOrSid";
    public static final String PROPERTY_SERVICE_ACCOUNT = "serviceAccount";
    public static final String PROPERTY_AUTO_START = "autoStart";
    private static final String PROPERTY_RESTART_ON_FAILURE = "restartOnFailure";
    private static final String TITLE_RESET_FAILURE_COUNT_AFTER_SECONDS = "Reset failure count after seconds";

    public InstallServiceActionBeanInfo() {
        super(NAME, "Installs a service. On Windows, this is done by executing the service launcher with the appropriate arguments. On Unix, if systemd is detected, a config file will be created in <tt>/etc/systemd/system</tt>, otherwise a link will be placed in <tt>/etc/init.d</tt>. On macOS, a LaunchDaemon will be created.  This action will be automatically reverted by the 'Uninstall files' action.<p>If a helper process with elevated privileges has been created by the \"Request privileges\" action, this action is pushed to the helper process. Please see the help topic on \"Elevation Of Privileges\" for more information.</p>", "installed", InstallServiceAction.class);
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_AUTO_START, (Class)this.getBeanClass(), (String)"Auto start", (String)"If the service should be started automatically at boot time.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)"description", (Class)this.getBeanClass(), (String)"Description", (String)"An optional description for the service.")));
        this.addPropertyDescriptor(this.reparent(Install4JPropertyDescriptor.create((String)PROPERTY_ACCOUNT_NAME_OR_SID, (Class)this.getBeanClass(), (String)"Account name or SID", (String)"The account name or a SID in String form.")));
        this.addPropertyDescriptor(this.reparent(Install4JPropertyDescriptor.create((String)"password", (Class)this.getBeanClass(), (String)"Password", (String)"The password for the specified account.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"windowsArguments", (Class)this.getBeanClass(), (String)"Windows arguments", (String)"Optional arguments passed to the main function of the service executable.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"windowsDependencies", (Class)this.getBeanClass(), (String)"Windows dependencies", (String)"Optional dependencies for Windows. Specify as a comma-separated list of services that must be started before this service. You do not have to enter core OS services these services will always be initialized before your service is launched.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"windowsDisplayName", (Class)this.getBeanClass(), (String)"Windows custom display name", (String)"Optional display name for the service. If empty, the service name is used.").setEmptyMessage("[Use service name]")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"windowsPriority", (Class)this.getBeanClass(), (String)"Windows priority", (String)"The base priority class for the service. This only applies to services generated by install4j.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_SERVICE_ACCOUNT, (Class)this.getBeanClass(), (String)"Account", (String)"The account the service should run under. Use Local System if you are not sure what you need.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"keepCurrentAccount", (Class)this.getBeanClass(), (String)"Keep current account", (String)"If the service was already installed, use the currently specified account instead of the values above.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_RESTART_ON_FAILURE, (Class)this.getBeanClass(), (String)"Restart on failure", (String)"If the service should be automatically restarted if it doesn't exit with exit code 0 or if it crashes.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"restartMillis", (Class)this.getBeanClass(), (String)"Restart after milliseconds", (String)"The time to wait before restarting the service after a failure, in milliseconds.").setParentProperty(PROPERTY_RESTART_ON_FAILURE));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"maxRestarts", (Class)this.getBeanClass(), (String)"Maximum number of restarts", (String)"The maximum number of restarts that should be performed. Enter 0 to not limit the number of restarts.<p>This failure count can be reset after a period without failures by setting the \"Reset failure count after seconds\" property to a non-zero value.</p>").setParentProperty(PROPERTY_RESTART_ON_FAILURE));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"resetSeconds", (Class)this.getBeanClass(), (String)TITLE_RESET_FAILURE_COUNT_AFTER_SECONDS, (String)"The time after which to reset the failure count for the maximum number of restarts to zero if there are no further failures, in seconds. Enter 0 to indicate that the failure count should never be reset.").setParentProperty(PROPERTY_RESTART_ON_FAILURE));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"interactive", (Class)this.getBeanClass(), (String)"Interactive", (String)"If the service can interact with the desktop. Not recommended for Windows Vista and higher.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"delayedAutoStart", (Class)this.getBeanClass(), (String)"Delayed auto start", (String)"If checked and \"Auto Start\" is also selected the service will be started after all other auto start services with an additional short delay.")));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)"macosIdentifier", (Class)this.getBeanClass(), (String)"macOS identifier", (String)"The launch daemon identifier for macOS. Typically, this is something like com.mycorp.myService.")));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)"additionalSystemdEntries", (Class)this.getBeanClass(), (String)"Additional systemd entries", (String)"Optional additional entries for the systemd config file. If this property contains default entry types, the default values will be replaced.", (String)"multiline")));
    }

    private Install4JPropertyDescriptor reparent(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_SERVICE_ACCOUNT);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> object == ServiceAccount.OTHER);
        return install4JPropertyDescriptor;
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        if (this.getPropertyValue(this.findPropertyDescriptor(PROPERTY_SERVICE_ACCOUNT), bean) == ServiceAccount.OTHER) {
            this.checkNotEmpty(PROPERTY_ACCOUNT_NAME_OR_SID, bean);
        }
    }
}

