/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.ejt.internal.d.i;
import com.install4j.api.actions.Action;
import com.install4j.api.beaninfo.ActionListInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beaninfo.VisibilityDiscriminator;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileActionBeanInfo;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.beans.actions.files.CopyFileAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.common.CategoryUtil;
import java.util.List;

@BeanInfo
public class CopyFileActionBeanInfo
extends AbstractRecursiveFileActionBeanInfo
implements ActionListInitializer,
BeanValidator {
    private static final String PROPERTY_DESTINATION_FILE = "destinationFile";
    private static final String PROPERTY_OVERWRITE_MODE = "overwriteMode";
    private static final String PROPERTY_UNINSTALL_MODE = "uninstallMode";
    private static final String PROPERTY_MODE = "mode";
    private static final String PROPERTY_DIRECTORY_MODE = "directoryMode";
    private static final String PROPERTY_SHARED = "shared";
    private static final String PROPERTY_DELAY = "delay";
    private static final String PROPERTY_TRIGGER_REBOOT = "triggerReboot";
    private static final String PROPERTY_DESTINATION_ROOT = "destinationRoot";
    private static final String PROPERTY_SYMLINK_MODE = "symlinkMode";
    private static final String PROPERTY_SYMLINK_FAILURE_MODE = "symlinkFailureMode";

    @BeanInfo
    public CopyFileActionBeanInfo() {
        this("Copy files and directories", "Copy files and directories. This action will be automatically reverted by the 'Uninstall files' action.", CopyFileAction.class);
    }

    protected CopyFileActionBeanInfo(String string, @i String string2, Class<? extends CopyFileAction> clazz) {
        super(string, string2, (Class<? extends AbstractRecursiveFileAction>)clazz, "File operations");
        this.addPropertyDescriptor(FilePropertyDescriptor.create((String)PROPERTY_DESTINATION_FILE, (Class)this.getBeanClass(), (String)"Destination directory", (String)"The destination directory. If you have selected a single source file, this can also be a file rather than a directory. The destination directory will not be created, it must exist before this action is executed, otherwise it will be treated as a destination file.", (FileSelectionMode)FileSelectionMode.FILES_AND_DIRECTORIES).setSortKey(Integer.valueOf(-10)));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_DESTINATION_FILE, Install4JPropertyDescriptor.create((String)PROPERTY_DESTINATION_ROOT, (Class)this.getBeanClass(), (String)"Resolve relative file in", (String)"A relative destination file can be resolved against the installation directory or against the root of the temporarily extracted archive.").setActionListShownKeys(new String[]{"archive"})));
        this.addFilesRootProperty();
        VisibilityDiscriminator visibilityDiscriminator = (bean, object) -> ((CopyFileAction)bean).getDestinationRoot() != ArchiveFileOperationRoot.ARCHIVE;
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_OVERWRITE_MODE, (Class)this.getBeanClass(), (String)"Overwrite mode", (String)"How to handle an existing destination file.").setVisibilityDiscriminator(visibilityDiscriminator));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_UNINSTALL_MODE, (Class)this.getBeanClass(), (String)"Uninstall mode", (String)"The mode how the uninstaller should handle the files created with this action.").setVisibilityDiscriminator(visibilityDiscriminator));
        String string3 = "Symlinks";
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SYMLINK_MODE, (Class)this.getBeanClass(), (String)"Symlink handling", (String)"If symlinks are created, absolute symlinks will always be created with the same absolute target path. Relative symlinks can either retain the same relative target path or point to the same file as the source as an absolute target.").setVisibilityDiscriminator(visibilityDiscriminator).setPropertyCategory(string3));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SYMLINK_FAILURE_MODE, (Class)this.getBeanClass(), (String)"On symlink creation failure", (String)"How the action should handle a failure to create symlinks. This mainly applies to Windows.").setVisibilityDiscriminator(visibilityDiscriminator).setPropertyCategory(string3));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)PROPERTY_MODE, (Class)this.getBeanClass(), (String)"Access mode", (String)"The UNIX access mode for files.").setVisibilityDiscriminator(visibilityDiscriminator)));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)PROPERTY_DIRECTORY_MODE, (Class)this.getBeanClass(), (String)"Directory access mode", (String)"The UNIX access mode for directories.").setVisibilityDiscriminator(visibilityDiscriminator)));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_SHARED, (Class)this.getBeanClass(), (String)"Shared file", (String)"If created files should be registered as a shared files.").setVisibilityDiscriminator(visibilityDiscriminator)));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_DELAY, (Class)this.getBeanClass(), (String)"Delay if necessary", (String)"If selected and a destination file cannot be replaced, the operation will be scheduled for the next reboot. The context method <tt>isRebootRequired()</tt> will return <tt>true</tt> in this case.").setVisibilityDiscriminator(visibilityDiscriminator)));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_TRIGGER_REBOOT, (Class)this.getBeanClass(), (String)"Trigger reboot if required", (String)"If selected and the operation is delayed until reboot, the user will be asked for a reboot automatically at the end of installation.").setVisibilityDiscriminator(visibilityDiscriminator)));
    }

    @Override
    protected String getFilesOperationClause() {
        return "to be copied";
    }

    @Override
    protected String getFilesDisplayName() {
        return "Source files or directories";
    }

    @Override
    protected boolean isRecursiveSupported() {
        return false;
    }

    @Override
    protected boolean isProgressSupported() {
        return true;
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.checkNotEmpty(PROPERTY_DESTINATION_FILE, bean);
    }

    public void initializeAction(Action action, List<String> list) {
        if (list.contains("archive")) {
            ((CopyFileAction)action).setDestinationRoot(ArchiveFileOperationRoot.ARCHIVE);
        }
    }
}

