/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools;

import com.install4j.buildtools.BuildToolHelper;
import com.install4j.buildtools.InstallationProvisioner;
import com.install4j.buildtools.InvalidConfigException;
import com.install4j.buildtools.shadowed.ejt.util.CommonPlatformUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTaskConfig {
    public static final byte[] BOM = new byte[]{-17, -69, -65};
    @Nullable
    private final File installDir;
    @Nullable
    private final File autoProvisioningCacheDir;
    @NotNull
    private final List<String> vmParameters;
    private File usedExecutableFile = null;

    public BaseTaskConfig(@Nullable File installDir, @Nullable File autoProvisioningCacheDir, @NotNull List<String> vmParameters) {
        this.installDir = installDir;
        this.autoProvisioningCacheDir = autoProvisioningCacheDir;
        this.vmParameters = vmParameters;
    }

    @Nullable
    public File getAutoProvisioningCacheDir() {
        String externalDistDir = System.getProperty("install4j.distDir");
        if (externalDistDir != null) {
            return new File(externalDistDir);
        }
        return this.autoProvisioningCacheDir;
    }

    @NotNull
    protected abstract String getExecutableName();

    @NotNull
    public final List<String> createCommandLine(@NotNull InstallationProvisioner installationProvisioner) throws InvalidConfigException {
        File executableFile = this.getExecutableFile(installationProvisioner);
        ArrayList<String> commandLine = new ArrayList<String>();
        if (!(CommonPlatformUtil.isWindows() || CommonPlatformUtil.isMacOS() && !BuildToolHelper.isMacosScript(executableFile))) {
            commandLine.add("/bin/sh");
        }
        commandLine.add(executableFile.getPath());
        this.addVmParameters(commandLine);
        this.buildCommandLine(commandLine);
        return commandLine;
    }

    public void cleanup() {
    }

    protected void addVmParameters(List<String> commandLine) {
        for (String vmParameter : this.vmParameters) {
            this.addVmParameter(vmParameter, commandLine);
        }
    }

    protected void buildCommandLine(List<String> commandLine) throws InvalidConfigException {
    }

    @NotNull
    protected final File getExecutableFile(@NotNull InstallationProvisioner installationProvisioner) {
        File file = BuildToolHelper.getInstall4jExecutableFile(this.getNonNullInstallDir(installationProvisioner), this.getExecutableName());
        if (!file.exists()) {
            throw new RuntimeException("Executable " + file + " does not exist");
        }
        this.usedExecutableFile = file;
        return file;
    }

    protected File getUsedExecutableFile() {
        return this.usedExecutableFile;
    }

    @Nullable
    private File getNonNullInstallDir(@NotNull InstallationProvisioner installationProvisioner) {
        if (this.installDir == null) {
            return installationProvisioner.provision();
        }
        return this.installDir;
    }

    protected void addVmParameter(String vmParameter, List<String> commandLine) {
        commandLine.add("-J" + vmParameter);
    }

    protected String join(Collection<String> strings, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (String string : strings) {
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(string);
        }
        return buffer.toString();
    }

    @Nullable
    public String getExtraLoggingOutput() {
        return null;
    }
}

