/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.ejt.internal.util.JavaVersionUtil;
import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.NullOutputStream;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.alert.AlertOptionPane;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.MediaPlatformType;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScriptClassOrigin;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.Script;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import com.install4j.runtime.launcher.MacLauncher;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateLog;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.StringUtil;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class InstallerUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String LOWER_CASE_OS_NAME = OS_NAME.toLowerCase(Locale.ENGLISH);
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String OS_ARCH = System.getProperty("os.arch", "");
    public static final String COMPLETION_CLASS_NAME = "Completion";
    public static final String COMPLETION_STATIC_CLASS_NAME = "CompletionStatic";
    private static final String SIMPLE_CLASS_NAME_PREFIX = "I4jScript_Internal_";
    public static final String SCRIPT_PACKAGE = "com.install4j.script";
    private static final String SCRIPT_PACKAGE_PREFIX = "com.install4j.script.";
    public static final String CLASS_NAME_PREFIX = "com.install4j.script.I4jScript_Internal_";
    public static final String STATIC_MEMBERS_CLASS_NAME = "com.install4j.script.I4jScript_Internal_0";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(I4jScript_Internal_\\d+|CompletionStatic)\\.java");
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("(I4jScript_Internal_\\d+|Completion|CompletionStatic)\\.java(?::(\\d+)|\\s+\\(at line (\\d+)\\))");
    public static final String TITLE_INSTALL4J = "install4j";
    private static final boolean UNIT_TEST = Boolean.getBoolean("install4j.unitTest");
    public static final boolean DEBUG = Boolean.getBoolean("install4j.debug");
    public static final boolean INTEGRATION_TEST = Boolean.getBoolean("install4j.installerIntegrationTest");
    public static final String REGKEY_EXE4J = "SOFTWARE\\ej-technologies\\exe4j\\";
    public static final String REGKEY_INSTALL4J = "SOFTWARE\\ej-technologies\\install4j\\";
    public static final String INSTALL4J_ARGUMENTS = "INSTALL4J_ARGUMENTS";
    private static final String REGVAL_INSTALL_STARTED = "InstallStarted";
    public static final String PROPNAME_ALLOW_AMBIGUOUS_COMMANDS = "jdk.lang.Process.allowAmbiguousCommands";
    private static ApplicationLauncher.Callback inProcessCallback;
    private static State state;
    private static final Pattern HTML_CONTENT_TYPE_PATTERN;
    private static volatile boolean exiting;
    private static Boolean headless;
    private static Object prefsLogger;
    private static Set<File> deleteOnExitFiles;

    public static boolean isExiting() {
        return exiting;
    }

    public static void setStartupVmParameters() {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        if (!Util.isWindows() && !Util.isMacOS() && System.getProperty("java.net.useSystemProxies") == null) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
    }

    public static boolean isInProcess() {
        return InstallerUtil.state.inProcess;
    }

    public static void setInProcess(boolean inProcess) {
        InstallerUtil.state.inProcess = inProcess;
        if (!inProcess) {
            InstallerUtil.setStartupVmParameters();
            InstallerUtil.disableNonSevereLogging();
            if (System.getProperty(PROPNAME_ALLOW_AMBIGUOUS_COMMANDS) == null) {
                System.setProperty(PROPNAME_ALLOW_AMBIGUOUS_COMMANDS, "false");
            }
        }
    }

    public static void setShutdownOnInProcessExit(boolean shutdownOnInProcessExit) {
        HelperCommunication.helperUnsupported();
        InstallerUtil.state.shutdownOnInProcessExit = shutdownOnInProcessExit;
    }

    public static void setInProcessCallback(ApplicationLauncher.Callback inProcessCallback) {
        HelperCommunication.helperUnsupported();
        InstallerUtil.inProcessCallback = inProcessCallback;
    }

    public static MediaPlatformType getMediaPlatformType() {
        if (UNIT_TEST) {
            return MediaPlatformType.getCurrent();
        }
        if (InstallerUtil.state.mediaPlatformType == null) {
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            if (config == null) {
                try {
                    config = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            InstallerUtil.state.mediaPlatformType = config.getMediaPlatformType();
        }
        return InstallerUtil.state.mediaPlatformType;
    }

    public static boolean isArchive() {
        if (InstallerUtil.state.archive == null) {
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            if (config == null) {
                try {
                    config = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            InstallerUtil.state.archive = config.isArchive();
        }
        return Objects.equals(InstallerUtil.state.archive, Boolean.TRUE);
    }

    public static void storeJreInfoForInstaller() {
        if (InstallerConfig.isInstaller()) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(new File(System.getProperty("user.dir"), "inst_jre.cfg")));
                pw.println(System.getProperty("java.home"));
                pw.close();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
    }

    public static String replaceHomeDir(String fileName) {
        if (fileName.startsWith("~")) {
            return Util.getUserHome() + fileName.substring(1);
        }
        return fileName;
    }

    public static File getAbsoluteFile(File file) {
        if (INTEGRATION_TEST && !file.isAbsolute()) {
            return new File(System.getProperty("user.dir"), file.getPath());
        }
        file.getAbsolutePath();
        return file.getAbsoluteFile();
    }

    public static long getPid(Process process) {
        try {
            if (!System.getProperty("java.version", "").startsWith("1.")) {
                return (Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process, new Object[0]);
            }
            if (InstallerUtil.isWindows()) {
                Field handleField = process.getClass().getDeclaredField("handle");
                handleField.setAccessible(true);
                return Misc.getPidFromHandle(((Number)handleField.get(process)).longValue());
            }
            Field pidField = process.getClass().getDeclaredField("pid");
            pidField.setAccessible(true);
            return ((Number)pidField.get(process)).longValue();
        }
        catch (Throwable e) {
            Logger.getInstance().log(e);
            return 0L;
        }
    }

    public static boolean isBlockingLauncherIntegration() {
        return InstallerUtil.state.blockingLauncherIntegration;
    }

    public static void setBlockingLauncherIntegration(boolean launcherIntegration) {
        InstallerUtil.state.blockingLauncherIntegration = launcherIntegration;
    }

    public static void initHelperState() {
        state = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> {
            InstallerUtil.getMediaPlatformType();
            return state;
        });
    }

    public static void exit(int status) {
        UpdateLog.logIfUpdater(1, "installer application finished with status " + status);
        HelperCommunication.helperUnsupported();
        AutomaticUpdate.checkAutoUpdateLauncher();
        if (!InstallerUtil.state.inProcess) {
            exiting = true;
            System.exit(status);
        } else {
            InstallerUtil.resetApplicationEnvironment();
            InstallerUtil.state.blockingLauncherIntegration = false;
            if (InstallerUtil.state.shutdownOnInProcessExit && status == 0) {
                if (inProcessCallback != null) {
                    inProcessCallback.prepareShutdown();
                }
                exiting = true;
                System.exit(0);
            } else if (inProcessCallback != null) {
                inProcessCallback.exited(status);
                inProcessCallback = null;
            }
            for (File file : deleteOnExitFiles) {
                if (!file.exists() || file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }

    public static void resetApplicationEnvironment() {
        ContextImpl.clearContext();
        InstallerConfig.clearCurrentApplication();
        FileInstaller.clearFileInstaller();
        AbstractBeanConfig.clearBeans();
        InstallerVariables.setReplaceI18nVariables(false);
        InstallerVariables.setReplaceInstallerAndCompilerVariables(false);
        InstallerVariables.clearVariables();
    }

    public static boolean isUnattended() {
        return InstallerUtil.state.unattended;
    }

    public static void setUnattended(boolean unattended) {
        InstallerUtil.state.unattended = unattended;
    }

    public static boolean isUnattendedAlerts() {
        return InstallerUtil.state.unattendedAlerts;
    }

    public static void setUnattendedAlerts(boolean unattendedAlerts) {
        InstallerUtil.state.unattendedAlerts = unattendedAlerts;
    }

    public static boolean isUnattendedWithProgress() {
        return InstallerUtil.state.unattendedWithProgress;
    }

    public static void setUnattendedWithProgress(boolean unattendedWithProgress) {
        InstallerUtil.state.unattendedWithProgress = unattendedWithProgress;
    }

    public static boolean isUnattendedWithoutAlerts() {
        return InstallerUtil.isUnattended() && !InstallerUtil.isUnattendedAlerts();
    }

    public static boolean isConsole() {
        return InstallerUtil.state.console;
    }

    public static void setConsole(boolean console) {
        InstallerUtil.state.console = console;
    }

    public static boolean isSolaris() {
        return Objects.equals(OS_NAME, "SunOS");
    }

    public static boolean isLinux() {
        return LauncherUtil.isLinux();
    }

    public static boolean isWindows() {
        return LauncherUtil.isWindows();
    }

    public static boolean isWindowsXP() {
        return LOWER_CASE_OS_NAME.startsWith("windows xp");
    }

    public static boolean isWindows2000() {
        return LOWER_CASE_OS_NAME.startsWith("windows 2000");
    }

    public static boolean isMacOS() {
        return LauncherUtil.isMacOS();
    }

    public static boolean isWindowsNT() {
        return (LOWER_CASE_OS_NAME.startsWith("windows nt") || LOWER_CASE_OS_NAME.startsWith("windowsnt")) && !OS_VERSION.startsWith("6");
    }

    public static boolean isAtLeastWindows2000() {
        try {
            return InstallerUtil.isWindows() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 5.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAtLeastWindowsVista() {
        return InstallerUtil.isWindows() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 6.0;
    }

    public static boolean isAtLeastWindows10() {
        return InstallerUtil.isWindows() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 10.0;
    }

    public static boolean isAtLeastWindows7() {
        try {
            return InstallerUtil.isWindows() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 6.1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWindowsVista() {
        return LOWER_CASE_OS_NAME.startsWith("windows vista") || LOWER_CASE_OS_NAME.startsWith("windows nt") && OS_VERSION.startsWith("6.0");
    }

    public static boolean isWindows7() {
        return LOWER_CASE_OS_NAME.startsWith("windows 7") || LOWER_CASE_OS_NAME.startsWith("windows vista") && OS_VERSION.startsWith("6.1");
    }

    public static boolean isWindows8() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && (OS_VERSION.startsWith("6.2") || OS_VERSION.startsWith("6.3"));
    }

    public static boolean isWindows10() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && OS_VERSION.startsWith("10.0");
    }

    public static boolean isWindows11() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && OS_VERSION.startsWith("10.0") && Misc.getOsBuildNumber() >= 22000;
    }

    public static boolean isWindows2003() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && OS_NAME.contains("2003");
    }

    public static boolean isWindows2008() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && OS_NAME.contains("2008");
    }

    public static boolean isWindows2012() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && OS_NAME.contains("2012");
    }

    public static boolean isWindows2016() {
        return LOWER_CASE_OS_NAME.startsWith("windows") && OS_NAME.contains("2016");
    }

    public static boolean isHpux() {
        return Objects.equals(OS_NAME, "HP-UX");
    }

    public static boolean isAix() {
        return Objects.equals(OS_NAME, "AIX");
    }

    public static boolean is32BitJVM() {
        return Objects.equals(System.getProperty("sun.arch.data.model", "32"), "32");
    }

    public static boolean isJava9Plus() {
        return JavaVersionUtil.isJava9Plus();
    }

    public static boolean isArm() {
        return OS_ARCH.startsWith("arm") || InstallerUtil.isAaarch64();
    }

    public static boolean isAaarch64() {
        return OS_ARCH.startsWith("aarch64");
    }

    public static boolean isUserInstallation(File file) {
        String userHome;
        String path = FileUtil.getCanonicalPath(file);
        if (path.startsWith(userHome = FileUtil.getCanonicalPath(new File(Util.getUserHome())))) {
            return true;
        }
        if (InstallerUtil.isWindows()) {
            File dir = FolderInfo.getSpecialFolder(1002, false);
            if (dir != null && path.startsWith(FileUtil.getCanonicalPath(dir))) {
                return true;
            }
            dir = FolderInfo.getSpecialFolder(11, false);
            if (dir != null && path.startsWith(FileUtil.getCanonicalPath(dir))) {
                return true;
            }
            dir = FolderInfo.getSpecialFolder(7, false);
            if (dir != null && path.startsWith(FileUtil.getCanonicalPath(dir))) {
                return true;
            }
            dir = FolderInfo.getSpecialFolder(1004, false);
            if (dir != null && path.startsWith(FileUtil.getCanonicalPath(dir))) {
                return true;
            }
        }
        return false;
    }

    public static String getStandardApplicationsDirectory(boolean userSpecific) {
        if (InstallerUtil.isWindows()) {
            if (userSpecific) {
                File dir = FolderInfo.getSpecialFolder(1002, false);
                if (dir == null) {
                    dir = FolderInfo.getSpecialFolder(11, false);
                }
                if (dir == null) {
                    dir = new File(Util.getUserHome());
                }
                return dir.getAbsolutePath();
            }
            return FolderInfo.getProgramFilesDirectory().getAbsolutePath();
        }
        if (InstallerUtil.isMacOS()) {
            if (userSpecific) {
                return new File(Util.getUserHome(), "Applications").getAbsolutePath();
            }
            return "/Applications";
        }
        if (userSpecific) {
            return Util.getUserHome();
        }
        File optDir = new File("/opt");
        String[] content = optDir.list();
        String rootDirName = optDir.exists() && content != null && content.length > 0 ? "/opt" : "/usr/local";
        File rootDir = new File(rootDirName);
        if (rootDir.exists()) {
            return rootDirName;
        }
        return Util.getUserHome();
    }

    public static File getInstallerFile(String fileName) {
        File file;
        String id = InstallerConfig.getCurrentApplicationId();
        if ((id == null || id.equals("installer")) && (file = InstallerUtil.getAbsoluteFile(new File(fileName))).exists()) {
            return file;
        }
        file = new File(ResourceHelper.getRuntimeDir(), fileName);
        if (file.exists() || !Util.isMacOS()) {
            return file;
        }
        return InstallerUtil.getAbsoluteFile(new File(fileName));
    }

    public static boolean isUnattendedAlerts(CommandLineOptions commandLineOptions, ExecutionMode executionMode) {
        if (executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS || executionMode == ExecutionMode.UNATTENDED && commandLineOptions.splash != null) {
            return commandLineOptions.unattendedAlerts || InstallerConfig.getCurrentApplication().isUnattendedAlerts();
        }
        return false;
    }

    public static ExecutionMode getExecutionMode(CommandLineOptions commandLineOptions, boolean alwaysAllowUnattended) {
        InstallerUtil.checkHeadlessJre();
        Application application = InstallerConfig.getCurrentApplication();
        return InstallerUtil.getExecutionMode(commandLineOptions, alwaysAllowUnattended, application, false);
    }

    public static ExecutionMode getExecutionMode(CommandLineOptions commandLineOptions, boolean alwaysAllowUnattended, Application application, boolean safeHeadlessCheck) {
        ExecutionMode executionMode = application.getExecutionMode();
        String vmExecutionMode = System.getProperty("install4j.executionMode");
        if (Objects.equals("gui", vmExecutionMode)) {
            executionMode = ExecutionMode.GUI;
        } else if (Objects.equals("console", vmExecutionMode)) {
            executionMode = ExecutionMode.CONSOLE;
        } else if (Objects.equals("unattended", vmExecutionMode)) {
            executionMode = ExecutionMode.UNATTENDED;
        }
        if (commandLineOptions.quiet && (application.isAllowUnattended() || alwaysAllowUnattended)) {
            executionMode = ExecutionMode.UNATTENDED;
        } else if (commandLineOptions.console && InstallerUtil.isAllowConsole(application)) {
            executionMode = ExecutionMode.CONSOLE;
        } else if (commandLineOptions.gui) {
            executionMode = ExecutionMode.GUI;
        }
        if (executionMode == ExecutionMode.GUI && Util.isUnixInstaller() && InstallerUtil.isAllowConsole(application) && application.isUnixFallbackToConsole() && InstallerUtil.isHeadless(safeHeadlessCheck)) {
            executionMode = ExecutionMode.CONSOLE;
        }
        return executionMode;
    }

    private static void checkHeadlessJre() {
        if (!InstallerUtil.isInProcess() && Util.isLinux()) {
            boolean forceHeadless;
            if (JavaVersionUtil.isJava9Plus()) {
                forceHeadless = !new File(System.getProperty("java.home"), "lib/libsplashscreen.so").isFile();
            } else {
                boolean archDirFound = false;
                boolean splashScreenFound = false;
                for (String arch : Arrays.asList("amd64", "i386", "aarch64", "aarch32", "ppc64le", "ppc64", "ppc", "sparc", "sparcv9")) {
                    File archDir = new File(System.getProperty("java.home"), "lib/" + arch);
                    if (!archDir.isDirectory()) continue;
                    archDirFound = true;
                    if (splashScreenFound) continue;
                    splashScreenFound = new File(archDir, "libsplashscreen.so").isFile();
                }
                boolean bl = forceHeadless = archDirFound && !splashScreenFound;
            }
            if (forceHeadless) {
                System.setProperty("java.awt.headless", "true");
                System.setProperty("javax.accessibility.assistive_technologies", VersionSpecificHelper.getAccessibilityProviderName());
            }
        }
    }

    public static boolean isHeadless(boolean safeHeadlessCheck) {
        if (safeHeadlessCheck) {
            return GraphicsEnvironment.isHeadless();
        }
        if (headless == null) {
            headless = InstallerUtil.initHeadless();
        }
        return headless;
    }

    private static boolean initHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        try {
            new Frame();
        }
        catch (Throwable e) {
            return true;
        }
        return false;
    }

    public static void setHeadlessProperty() {
        System.setProperty("java.awt.headless", "true");
    }

    public static String getSupportedSystemLanguageId() {
        Logger logger = Logger.getInstance();
        Locale locale = Locale.getDefault();
        String systemLanguageId = locale.getLanguage();
        logger.info(null, "System language '" + systemLanguageId + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(systemLanguageId) != null) {
            return systemLanguageId;
        }
        systemLanguageId = systemLanguageId + "_" + locale.getCountry();
        logger.info(null, "System locale '" + systemLanguageId + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(systemLanguageId) != null) {
            return systemLanguageId;
        }
        logger.info(null, "System locale not found in available languages");
        return null;
    }

    public static String insertBeanNames(String errorMessage, Map<String, ScriptClassOrigin> classNameToScriptClassOrigin) {
        String[] lines = errorMessage.split("\n");
        StringBuffer buffer = new StringBuffer();
        for (String line : lines) {
            InstallerUtil.addBeanNameToBuffer(line, classNameToScriptClassOrigin, buffer, null);
            buffer.append(InstallerUtil.replaceLineNumber(line, classNameToScriptClassOrigin));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private static void addBeanNameToBuffer(String line, Map<String, ScriptClassOrigin> classNameToScriptClassOrigin, StringBuffer buffer, Set<String> handledScriptClassNames) {
        String className;
        ScriptClassOrigin scriptClassOrigin;
        Matcher matcher = CLASS_NAME_PATTERN.matcher(line);
        matcher.reset(line);
        if (matcher.find() && (scriptClassOrigin = InstallerUtil.getScriptClassOrigin(className = matcher.group(1), classNameToScriptClassOrigin)) != null && (handledScriptClassNames == null || !handledScriptClassNames.contains(className))) {
            String propertyName;
            String parentScreen;
            String beanId;
            buffer.append("In ");
            buffer.append(scriptClassOrigin.getBeanType());
            String beanName = scriptClassOrigin.getBeanName();
            if (!beanName.isEmpty()) {
                buffer.append(" \"");
                buffer.append(beanName);
                buffer.append('\"');
            }
            if (!(beanId = scriptClassOrigin.getBeanId()).isEmpty()) {
                buffer.append(" [ID ");
                buffer.append(beanId);
                buffer.append(']');
            }
            if (!(parentScreen = scriptClassOrigin.getParentScreen()).isEmpty()) {
                buffer.append(" (screen \"");
                buffer.append(parentScreen);
                buffer.append("\")");
            }
            if (!(propertyName = scriptClassOrigin.getPropertyName()).isEmpty()) {
                buffer.append(", property \"");
                buffer.append(propertyName);
                buffer.append('\"');
            }
            buffer.append(":\n");
            if (handledScriptClassNames != null) {
                handledScriptClassNames.add(className);
            }
        }
    }

    private static ScriptClassOrigin getScriptClassOrigin(String simpleClassName, Map<String, ScriptClassOrigin> classNameToScriptClassOrigin) {
        String className = (simpleClassName.equals(COMPLETION_CLASS_NAME) || simpleClassName.equals(COMPLETION_STATIC_CLASS_NAME) ? "code." : SCRIPT_PACKAGE_PREFIX) + simpleClassName;
        return classNameToScriptClassOrigin.get(className);
    }

    public static String prependBeanOrigin(String errorMessage, Map<String, ScriptClassOrigin> classNameToScriptClassOrigin) {
        String[] lines = errorMessage.split("\n");
        StringBuffer buffer = new StringBuffer();
        HashSet<String> handledScriptClassNames = new HashSet<String>();
        for (String line : lines) {
            InstallerUtil.addBeanNameToBuffer(line, classNameToScriptClassOrigin, buffer, handledScriptClassNames);
        }
        for (String line : lines) {
            buffer.append(InstallerUtil.replaceLineNumber(line, classNameToScriptClassOrigin)).append('\n');
        }
        return buffer.toString();
    }

    private static String replaceLineNumber(String line, Map<String, ScriptClassOrigin> classNameToScriptClassOrigin) {
        Matcher matcher = LINE_NUMBER_PATTERN.matcher(line);
        if (matcher.find()) {
            ScriptClassOrigin scriptClassOrigin = InstallerUtil.getScriptClassOrigin(matcher.group(1), classNameToScriptClassOrigin);
            int lineNumberGroupIndex = matcher.group(2) != null ? 2 : 3;
            String lineNumberString = matcher.group(lineNumberGroupIndex);
            int lineNumber = Integer.parseInt(lineNumberString);
            if (scriptClassOrigin != null) {
                int scriptStartLine = scriptClassOrigin.getPackageLineCount() + scriptClassOrigin.getImportLineCount() + scriptClassOrigin.getHeaderLineCount();
                if (lineNumber >= scriptStartLine && lineNumber <= scriptStartLine + scriptClassOrigin.getScriptLineCount()) {
                    int scriptLineNumber = lineNumber - scriptClassOrigin.getHeaderLineCount();
                    return InstallerUtil.replaceLineNumber(line, matcher, lineNumberGroupIndex, scriptLineNumber, "");
                }
                if (lineNumber > scriptClassOrigin.getPackageLineCount() && lineNumber <= scriptClassOrigin.getPackageLineCount() + scriptClassOrigin.getImportLineCount()) {
                    int scriptLineNumber = lineNumber - scriptClassOrigin.getPackageLineCount();
                    return InstallerUtil.replaceLineNumber(line, matcher, lineNumberGroupIndex, scriptLineNumber, "");
                }
                return InstallerUtil.replaceLineNumber(line, matcher, lineNumberGroupIndex, lineNumber, "*");
            }
        }
        return line;
    }

    private static String replaceLineNumber(String line, Matcher matcher, int lineNumberGroupIndex, int scriptLineNumber, String prefix) {
        return line.substring(0, matcher.start(lineNumberGroupIndex)) + prefix + scriptLineNumber + line.substring(matcher.end(lineNumberGroupIndex));
    }

    public static void disablePreferencesLogging() {
    }

    private static synchronized void disablePreferencesLoggingImpl() {
        if (!Boolean.getBoolean("install4j.noLoggingFix")) {
            try {
                if (prefsLogger == null) {
                    try {
                        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("java.util.prefs");
                        logger.setUseParentHandlers(false);
                        prefsLogger = logger;
                    }
                    catch (Throwable logger) {}
                }
            }
            catch (Throwable logger) {
                // empty catch block
            }
            try {
                PlatformLoggingMXBean logging = ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class);
                logging.setLoggerLevel("java.util.prefs", "OFF");
            }
            catch (Throwable logging) {
                // empty catch block
            }
            PrintStream out = System.out;
            PrintStream err = System.err;
            System.setOut(new PrintStream(new NullOutputStream()));
            System.setErr(new PrintStream(new NullOutputStream()));
            try {
                try {
                    Preferences.userRoot().flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                System.setOut(out);
                System.setErr(err);
            }
        }
    }

    public static void disableNonSevereLogging() {
        try {
            java.util.logging.Logger log = LogManager.getLogManager().getLogger("");
            for (Handler h : log.getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                h.setLevel(Level.SEVERE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean is64BitWindows() {
        return InstallerUtil.is64BitWindowsArch(System.getenv("PROCESSOR_ARCHITECTURE")) || InstallerUtil.is64BitWindowsArch(System.getenv("PROCESSOR_ARCHITEW6432"));
    }

    private static boolean is64BitWindowsArch(String arch) {
        return arch != null && (arch.equalsIgnoreCase("AMD64") || arch.equalsIgnoreCase("IA64") || arch.equalsIgnoreCase("ARM64"));
    }

    public static String[] getExtraCommandLineParameters() {
        return InstallerUtil.state.extraCommandLineParameters;
    }

    public static String[] getCommandLineParameters() {
        return InstallerUtil.state.commandLineParameters;
    }

    public static String getSplash(CommandLineOptions commandLineOptions, ExecutionMode executionMode) {
        String splash = commandLineOptions.splash;
        if (executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS && splash == null) {
            splash = InstallerConfig.getCurrentApplication().getSplashMessage();
        }
        return splash;
    }

    public static boolean isAllowConsole(Application application) {
        return application.isAllowConsole() && (!InstallerUtil.isWindows() || !application.isDisableConsoleOnWindows());
    }

    public static CommandLineOptions parseCommandLine(String[] args) {
        HelperCommunication.helperUnsupported();
        InstallerUtil.state.commandLineParameters = args;
        if (!HelperCommunication.getInstance().isElevatedHelper()) {
            try {
                String envCommandLine = System.getenv().get(INSTALL4J_ARGUMENTS);
                if (envCommandLine != null) {
                    ArrayList<String> argList = new ArrayList<String>();
                    StringUtil.splitupQuotedList(argList, envCommandLine, " ");
                    args = argList.toArray(new String[0]);
                }
            }
            catch (Throwable envCommandLine) {
                // empty catch block
            }
        }
        CommandLineOptions commandLineOptions = new CommandLineOptions(args);
        InstallerUtil.state.extraCommandLineParameters = commandLineOptions.extraCommandLineOptions.toArray(new String[0]);
        return commandLineOptions;
    }

    public static void showHelp(boolean console) {
        ArrayList<String[]> options = new ArrayList<String[]>();
        Application application = InstallerConfig.getCurrentApplication();
        Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguages().get(0));
        options.add(new String[]{"-varfile [file]", Messages.getString(".HelpResponseFile")});
        if (InstallerUtil.isAllowConsole(application)) {
            options.add(new String[]{"-c", Messages.getString(".HelpConsoleMode")});
        }
        if (application.isAllowUnattended()) {
            options.add(new String[]{"-q", Messages.getString(".HelpUnattendedMode")});
            if (application instanceof InstallerApplication) {
                options.add(new String[]{"-dir [directory]", Messages.getString(".HelpUnattendedDir")});
                options.add(new String[]{"-overwrite", Messages.getString(".HelpUnattendedOverwrite")});
                options.add(new String[]{"-nofilefailures", Messages.getString(".HelpNoFileFailures")});
            }
            options.add(new String[]{"-splash [title]", Messages.getString(".HelpUnattendedSplash")});
            options.add(new String[]{"-alerts", Messages.getString(".HelpUnattendedAlerts")});
            if (InstallerUtil.isWindows()) {
                options.add(new String[]{"-console", Messages.getString(".HelpUnattendedConsole")});
            }
        }
        if (InstallerUtil.isWindows()) {
            options.add(new String[]{"-manual", Messages.getString(".HelpManual")});
        }
        if (application.getExecutionMode() != ExecutionMode.GUI) {
            options.add(new String[]{"-g", Messages.getString(".HelpGuiMode")});
        }
        options.add(new String[]{"-Dname=value", Messages.getString(".HelpSystemProperties")});
        options.add(new String[]{"-h", Messages.getString(".HelpHelp")});
        try {
            ScriptProperty helpCustomizer = application.getHelpCustomizer();
            if (helpCustomizer != null && !Objects.equals(helpCustomizer.getValue(), "")) {
                ((Script)Class.forName(helpCustomizer.getValue(), true, Install4jClassLoader.getInstance()).newInstance()).evaluate(null, application, new Object[]{options});
            }
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
        }
        InstallerUtil.showHelp(Messages.getString(".HelpHeaderLabel"), options, console);
    }

    private static void showHelp(String header, List<String[]> options, boolean console) {
        if (console) {
            InstallerUtil.showConsoleHelp(header, options);
        } else {
            try {
                InstallerUtil.showGuiHelp(header, options);
            }
            catch (Throwable e) {
                InstallerUtil.showConsoleHelp(header, options);
            }
        }
    }

    private static void showGuiHelp(String header, List<String[]> options) {
        StringBuilder buffer = new StringBuilder("<html>");
        buffer.append(header);
        buffer.append("<br><br><table border=0 cellspacing=0>");
        for (String[] option : options) {
            buffer.append("<tr><td><b>");
            buffer.append(option[0]);
            buffer.append("</b></td><td>&nbsp;</td><td>");
            buffer.append(option[1]);
            buffer.append("</tr>");
        }
        buffer.append("</table>");
        AlertOptionPane.showMessageDialog(null, buffer.toString(), Messages.getString(".HelpWindowTitle"), 1);
    }

    private static void showConsoleHelp(String header, List<String[]> options) {
        ConsoleImpl console = ConsoleImpl.getInstance();
        console.println(header);
        console.println();
        int maxLength = 0;
        for (String[] option : options) {
            maxLength = Math.max(option[0].length(), maxLength);
        }
        for (String[] option : options) {
            console.print(option[0]);
            console.print(StringUtil.repeat(" ", maxLength + 1 - option[0].length()));
            console.println(option[1]);
        }
    }

    private static List<InstallerConfig> getAddOnApplicationConfigsFromRuntimeDir(File runtimeDir) {
        ArrayList<InstallerConfig> ret = new ArrayList<InstallerConfig>();
        File[] files = runtimeDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith("i4jparams.conf.")) continue;
                try {
                    ret.add(InstallerConfig.getGeneralConfigFromFile(file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static List<InstallerConfig> getAddOnApplicationConfigs(File installationDirectory) {
        if (installationDirectory.exists()) {
            File oldConfigFile = new File(installationDirectory, ".install4j/i4jparams.conf");
            if (oldConfigFile.exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(oldConfigFile.getParentFile());
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacOS() && (oldConfigFile = new File(installationDirectory, "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(oldConfigFile.getParentFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static InstallerConfig getOldApplicationConfig(File installationDirectory) {
        if (installationDirectory.isDirectory()) {
            File oldConfigFile = new File(installationDirectory, ".install4j/i4jparams.conf");
            if (oldConfigFile.isFile()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(oldConfigFile);
                }
                catch (Throwable throwable) {
                }
            } else if (Util.isMacosInstaller()) {
                File singleBundleDirectory;
                oldConfigFile = new File(installationDirectory, "Contents/Resources/app/.install4j/i4jparams.conf");
                if (oldConfigFile.isFile()) {
                    try {
                        return InstallerConfig.getGeneralConfigFromFile(oldConfigFile);
                    }
                    catch (Throwable throwable) {
                    }
                } else if (InstallerConfig.getCurrentInstance() != null && (singleBundleDirectory = MacLauncher.getSingleBundleDirectory()) != null && (oldConfigFile = new File(new File(installationDirectory, singleBundleDirectory.getName()), "Contents/Resources/app/.install4j/i4jparams.conf")).isFile()) {
                    try {
                        return InstallerConfig.getGeneralConfigFromFile(oldConfigFile);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static String getOldApplicationId(File installationDirectory) {
        InstallerConfig oldInstallerConfig = InstallerUtil.getOldApplicationConfig(installationDirectory);
        if (oldInstallerConfig != null) {
            if (oldInstallerConfig.getApplicationId().contains("${")) {
                return null;
            }
            return oldInstallerConfig.getApplicationId();
        }
        return null;
    }

    public static boolean checkWritableInstallationDirectory(File destDir, boolean showMessage) {
        ExecutionContext executionContext = ContentInstaller.getExecutionContext();
        Logger.getInstance().log(null, "checking writable with " + (Object)((Object)executionContext), true);
        boolean writable = HelperCommunication.getInstance().fetchBoolean(executionContext, context -> {
            File uncFile;
            File usedDir = destDir;
            if (InstallerUtil.isOnNonExistingDrive(usedDir) && context.hasBeenElevated() && (uncFile = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, unelevatedContext -> {
                String universalPathName = FolderInfo.getUniversalPathName(destDir.getAbsolutePath());
                if (!Objects.equals(universalPathName, destDir.getAbsolutePath())) {
                    File uncFile1 = new File(universalPathName);
                    InstallerConfig.getCurrentInstance().addUncMapping(destDir, uncFile1);
                    Logger.getInstance().log(null, "using unc path " + universalPathName, true);
                    if (unelevatedContext instanceof InstallerContext) {
                        ((InstallerContext)unelevatedContext).setInstallationDirectory(unelevatedContext.getInstallationDirectory());
                    }
                    return uncFile1;
                }
                return null;
            })) != null) {
                usedDir = uncFile;
            }
            return InstallerUtil.checkWritable(usedDir);
        });
        if (!writable && showMessage) {
            Util.showMessage(Messages.format(Messages.getString(".NoWritePermissions2"), destDir), 2);
        }
        return writable;
    }

    public static boolean isOnNonExistingDrive(File destDir) {
        if (destDir != null && Util.isWindows()) {
            while (destDir.getParent() != null) {
                destDir = destDir.getParentFile();
            }
            if (destDir.getAbsolutePath().length() >= 2 && destDir.getAbsolutePath().charAt(1) == ':') {
                return !destDir.isDirectory();
            }
        }
        return false;
    }

    public static boolean checkWritable(File destDir) {
        ArrayList<File> dirList = new ArrayList<File>();
        for (File curDir = destDir; curDir != null; curDir = curDir.getParentFile()) {
            dirList.add(curDir);
        }
        ArrayList<File> createdDirs = new ArrayList<File>();
        for (int i = dirList.size() - 1; i >= 0; --i) {
            File curDir = (File)dirList.get(i);
            if (!curDir.mkdir()) continue;
            createdDirs.add(curDir);
        }
        File testDir = new File(destDir, "i4j_writeperm_test");
        testDir.delete();
        boolean writable = testDir.mkdir();
        testDir.delete();
        for (int i = createdDirs.size() - 1; i >= 0; --i) {
            File curDir = (File)createdDirs.get(i);
            curDir.delete();
        }
        return writable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadFile(File file, String languageId) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        try {
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip")) return InstallerUtil.readString(Files.newInputStream(file.toPath(), new OpenOption[0]), InstallerUtil.getDefaultEncoding(file.getName()));
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry zipEntry;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                do {
                    if (!entries.hasMoreElements()) return null;
                } while (!(zipEntry = entries.nextElement()).getName().startsWith(languageId + "."));
                String string = InstallerUtil.readString(zipFile.getInputStream(zipEntry), InstallerUtil.getDefaultEncoding(zipEntry.getName()));
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        StringWriter writer = new StringWriter();
        try (InputStreamReader reader = encoding.trim().isEmpty() ? new FileReader(file) : new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), encoding);){
            int i;
            char[] buffer = new char[8192];
            while ((i = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, i);
            }
        }
        return writer.toString();
    }

    public static void writeTextFile(String text, File file, String encoding, boolean append) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream fileOut = new FileOutputStream(file.getAbsolutePath(), append);){
            BufferedWriter writer;
            if (encoding != null && !encoding.trim().isEmpty()) {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOut, encoding));
                }
                catch (UnsupportedEncodingException e) {
                    Logger.getInstance().log(e);
                    writer = new BufferedWriter(new OutputStreamWriter(fileOut));
                }
            } else {
                writer = new BufferedWriter(new OutputStreamWriter(fileOut));
            }
            try (BufferedWriter out = new BufferedWriter(writer);){
                String line;
                BufferedReader in = new BufferedReader(new StringReader(text));
                boolean first = true;
                while ((line = in.readLine()) != null) {
                    if (!first) {
                        out.newLine();
                    } else {
                        first = false;
                    }
                    out.write(line);
                }
                if (text.endsWith("\n")) {
                    out.newLine();
                }
            }
        }
    }

    private static String getDefaultEncoding(String fileName) {
        return fileName.toLowerCase(Locale.ENGLISH).endsWith(".properties") ? "ISO-8859-1" : "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream in, String defaultEncoding) throws IOException {
        try {
            Matcher matcher;
            int size;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((size = in.read(buffer)) != -1) {
                out.write(buffer, 0, size);
            }
            byte[] stringBytes = out.toByteArray();
            String string = new String(stringBytes, defaultEncoding);
            if (string.indexOf(60) >= 0 && (matcher = HTML_CONTENT_TYPE_PATTERN.matcher(string)).find()) {
                String charset = matcher.group(3);
                try {
                    if (!charset.equalsIgnoreCase("UTF-8") && Charset.isSupported(charset)) {
                        string = new String(stringBytes, charset);
                    }
                }
                catch (IllegalCharsetNameException e) {
                    System.err.println("Encoding " + charset + " in HTML text is invalid.");
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println("Encoding " + charset + " in HTML text is not supported by the JRE.");
                }
            }
            String string2 = string = string.replaceAll("\ufeff", "");
            return string2;
        }
        finally {
            in.close();
        }
    }

    public static String sanitizeHTML(String text) {
        String lowerCaseText = text.toLowerCase(Locale.ENGLISH);
        boolean html = lowerCaseText.contains("<html");
        if (html) {
            int headStartPos = lowerCaseText.indexOf("<head>");
            int headEndPos = lowerCaseText.indexOf("</head>");
            if (headStartPos > -1 && headEndPos > headStartPos) {
                text = text.substring(0, headStartPos) + text.substring(headStartPos + 6, headEndPos) + text.substring(headEndPos + 7);
            }
        }
        return text;
    }

    public static String cleanupName(String name) {
        if (name.endsWith("//") || name.endsWith("\\\\")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void reportException(Throwable t) {
        UpdateLog.logIfUpdater(1, t);
        Logger.getInstance().log(t);
        if (DEBUG) {
            System.err.println(Util.getAnnotatedStackTrace(t));
        } else {
            if (!Boolean.getBoolean("install4j.suppressFontErrorMessage") && InstallerUtil.handleFontRelatedException(t)) {
                return;
            }
            File tempFile = null;
            try {
                tempFile = File.createTempFile("install4jError", ".log");
                try (PrintWriter pw = new PrintWriter(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
                    pw.println("Exception:");
                    pw.println();
                    pw.print(Util.getAnnotatedStackTrace(t));
                    pw.println();
                    pw.println("System properties:");
                    pw.println();
                    for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                        pw.print(entry.getKey());
                        pw.print("=");
                        pw.println(entry.getValue());
                    }
                }
                tempFile = InstallerUtil.copyTempFile(tempFile);
            }
            catch (IOException pw) {
                // empty catch block
            }
            if (tempFile != null) {
                try {
                    tempFile = tempFile.getCanonicalFile();
                }
                catch (IOException pw) {
                    // empty catch block
                }
            }
            String message = "An error occurred:\n" + t + "\nError log: " + (tempFile == null ? "" : tempFile.getPath());
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)sw, true));
            String stackTrace = sw.toString();
            if (InstallerUtil.state.unattended || InstallerUtil.state.console) {
                ConsoleImpl.getInstance().println(message);
                ConsoleImpl.getInstance().printStackTrace(t);
            } else if (stackTrace.indexOf("X11") > 0 || t instanceof NoClassDefFoundError && stackTrace.indexOf("java.awt.Container") > 0) {
                if (Boolean.getBoolean("install4j.printX11Exception")) {
                    t.printStackTrace();
                }
                InstallerUtil.displayXMessage();
            } else {
                File usedFile = tempFile;
                GUIHelper.invokeOnEDT(() -> {
                    try {
                        if (usedFile == null) {
                            JOptionPane.showMessageDialog(null, message, TITLE_INSTALL4J, 0);
                        } else {
                            int result = JOptionPane.showOptionDialog(null, message, TITLE_INSTALL4J, -1, 0, null, new String[]{"OK", "Show Log File"}, null);
                            if (result == 1) {
                                GUIHelper.showURL(usedFile.toURI().toString());
                            }
                        }
                    }
                    catch (Throwable t2) {
                        if (Util.isWindowsInstaller() || Boolean.getBoolean("install4j.suppressX11Message")) {
                            System.err.println(message);
                            t.printStackTrace();
                        }
                        InstallerUtil.displayXMessage();
                    }
                });
            }
        }
    }

    private static boolean handleFontRelatedException(Throwable t) {
        String message = t.getMessage();
        if (message != null && message.contains("font")) {
            System.err.println("Error: " + message);
            System.err.println("The JRE is not fully functional on this system.");
            return true;
        }
        return false;
    }

    private static File copyTempFile(File tempFile) throws IOException {
        try {
            String mediaDir = (String)InstallerVariables.getVariable("sys.mediaDir");
            if (mediaDir != null) {
                File mediaDirTempFile = new File(mediaDir, tempFile.getName());
                FileUtil.copyFile(tempFile, mediaDirTempFile);
                tempFile = mediaDirTempFile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tempFile;
    }

    private static void displayXMessage() {
        if (InstallerUtil.isConsole() || InstallerUtil.isUnattended()) {
            if (InstallerUtil.isPossibleDisplayProblem()) {
                System.err.println("The DISPLAY environment variable is set to an inaccessible X-server.");
                System.err.println("Please execute \"export DISPLAY=\" and try again.");
            } else {
                System.err.println("Headless mode does not work on your system with the used Java runtime");
                System.err.println("environment.");
            }
        } else {
            String serverName = "an X server";
            if (Util.isMacOS()) {
                serverName = "a desktop session";
            }
            System.err.println("Could not display the GUI. This application needs access to " + serverName + ".");
            if (InstallerUtil.isAllowConsole(InstallerConfig.getCurrentApplication())) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in console mode without");
                System.err.println("access to " + serverName + " by passing the argument -c");
                System.err.println("*******************************************************************");
            } else if (InstallerConfig.getCurrentApplication().isAllowUnattended()) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in unattended mode without");
                System.err.println("access to " + serverName + " by passing the argument -q");
                System.err.println("*******************************************************************");
            }
        }
    }

    private static boolean isPossibleDisplayProblem() {
        if (Util.isWindows() || Util.isMacOS()) {
            return false;
        }
        String display = System.getenv("DISPLAY");
        return display != null && !display.isEmpty();
    }

    public static void registerStarted(boolean hideWindow) {
        HelperCommunication.helperUnsupported();
        if (InstallerUtil.isWindows()) {
            String valueName = "InstallStarted_" + Win32CommunicationBackend.getCurrentProcessId();
            if (WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, valueName) != null) {
                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, valueName, hideWindow ? 2 : 0);
            }
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, REGVAL_INSTALL_STARTED, hideWindow ? 2 : 0);
        }
    }

    public static String getVerboseVariableDefinition(String variableName, Object value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(variableName);
        buffer.append("=");
        buffer.append(StringUtil.toStringWithArrays(value));
        if (value != null) {
            buffer.append("[");
            buffer.append(value.getClass());
            buffer.append("]");
        }
        return buffer.toString();
    }

    public static String getAnnotatedStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        if (config == null) {
            return sw.toString();
        }
        return InstallerUtil.prependBeanOrigin(sw.toString(), config.getClassNameToScriptClassOrigin());
    }

    public static void deleteOnExit(File file) {
        if (InstallerUtil.isInProcess()) {
            deleteOnExitFiles.add(file);
        } else {
            file.deleteOnExit();
        }
    }

    static {
        state = new State();
        HTML_CONTENT_TYPE_PATTERN = Pattern.compile("<html\\s*>.*<meta\\s+http-equiv\\s*=\\s*([\"'])Content-Type\\1\\s+content\\s*=\\s*([\"'])text/html;\\s+charset=(.*?)\\2", 34);
        deleteOnExitFiles = new HashSet<File>();
        InstallerUtil.disablePreferencesLoggingImpl();
        if (!(InstallerUtil.isWindows() || InstallerUtil.isMacOS() || Util.hasFullAdminRights())) {
            PreferencesUtil.setDisableSystemRoot(true);
        }
    }

    public static class State
    implements Serializable {
        boolean unattended = false;
        boolean unattendedAlerts = false;
        boolean unattendedWithProgress = false;
        boolean console = false;
        MediaPlatformType mediaPlatformType = null;
        Boolean archive = null;
        String[] commandLineParameters = new String[0];
        String[] extraCommandLineParameters = new String[0];
        boolean inProcess = true;
        boolean shutdownOnInProcessExit = false;
        boolean blockingLauncherIntegration = false;
    }

    public static class CommandLineOptions {
        public static final String PROPERTY_QUIET_OVERWRITE = "install4j.quietOverwrite";
        public static final String PROPERTY_NO_FILE_FAILURES = "install4j.noFileFailures";
        public boolean help = false;
        public boolean quiet = false;
        public boolean console = false;
        public boolean gui = false;
        public File installDir = null;
        public String manualTempDir = null;
        public boolean quietOverwrite = Boolean.getBoolean("install4j.quietOverwrite");
        public boolean noFileFailures = Boolean.getBoolean("install4j.noFileFailures");
        public int wait = 0;
        public String splash = null;
        public boolean unattendedAlerts = false;
        public final Map<String, String> commandLineVars = new HashMap<String, String>();
        public final List<String> extraCommandLineOptions = new ArrayList<String>();
        public String varFileName;

        public CommandLineOptions(String[] args) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (Objects.equals(arg, "-q") && !this.console && !this.gui) {
                    this.quiet = true;
                    continue;
                }
                if (Objects.equals(arg, "-c") && !this.quiet && !this.gui) {
                    this.console = true;
                    continue;
                }
                if (Objects.equals(arg, "-g") && !this.console && !this.quiet) {
                    this.gui = true;
                    continue;
                }
                if (Objects.equals(arg, "-overwrite")) {
                    this.quietOverwrite = true;
                    continue;
                }
                if (Objects.equals(arg, "-nofilefailures")) {
                    this.noFileFailures = true;
                    continue;
                }
                if (Objects.equals(arg, "-h") || Objects.equals(arg, "-help") || Objects.equals(arg, "/?")) {
                    this.help = true;
                    continue;
                }
                if (Objects.equals(arg, "-dir") && i + 1 < args.length) {
                    this.installDir = new File(args[++i].trim());
                    continue;
                }
                if ((arg.equals("-temp") || arg.equals("/temp")) && i + 1 < args.length) {
                    this.manualTempDir = args[++i].trim();
                    continue;
                }
                if (Objects.equals(arg, "-wait") && i + 1 < args.length) {
                    this.wait = Integer.parseInt(args[++i]);
                    continue;
                }
                if (Objects.equals(arg, "-varfile") && i + 1 < args.length) {
                    this.varFileName = args[++i];
                    continue;
                }
                if (Objects.equals(arg, "-splash") && i + 1 < args.length) {
                    this.splash = args[++i];
                    continue;
                }
                if (Objects.equals(arg, "-alerts")) {
                    this.unattendedAlerts = true;
                    continue;
                }
                boolean systemProperty = arg.startsWith("-D");
                boolean var = arg.startsWith("-V");
                if (systemProperty || var) {
                    int equalPos = arg.indexOf(61);
                    if (equalPos <= -1 || arg.length() <= equalPos + 1) continue;
                    String key = arg.substring(2, equalPos);
                    String value = arg.substring(equalPos + 1);
                    if (systemProperty) {
                        System.setProperty(key, value);
                        continue;
                    }
                    this.commandLineVars.put(key, value);
                    continue;
                }
                this.extraCommandLineOptions.add(arg);
            }
        }
    }
}

