/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Objects;
import javax.swing.InputVerifier;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;

public abstract class FormattedTextfieldComponent
extends TextfieldComponent {
    @Override
    protected JTextComponent createTextComponent() {
        final JFormattedTextField textField = new JFormattedTextField(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.updateFormatter(textField);
        this.applyTextFieldProperties(textField);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!FormattedTextfieldComponent.this.isCheckIfEmpty()) {
                    String text = textField.getText();
                    int keyCode = e.getKeyCode();
                    int insertIndex = textField.getCaretPosition();
                    if (Objects.equals(textField.getSelectedText(), textField.getText()) || text.length() == 1 && (keyCode == 8 && insertIndex == 1 || keyCode == 127 && insertIndex == 0)) {
                        textField.setValue(null);
                    }
                }
            }
        });
        return textField;
    }

    @Override
    protected void initText(JTextComponent textComponent) {
        JFormattedTextField textField = (JFormattedTextField)textComponent;
        this.updateFormatter(textField);
        super.initText(textComponent);
        Object initValue = this.getInitValue(this.getInitialText(), this.getVariableName(), Object.class);
        if (initValue != null && !initValue.toString().isEmpty()) {
            try {
                textField.commitEdit();
                textField.setValue(textField.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean checkCompleted() {
        JFormattedTextField textField = (JFormattedTextField)this.getTextComponent();
        try {
            textField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return super.checkCompleted();
    }

    protected abstract DefaultFormatter createFormatter();

    @Override
    public Object[] createInputVerifierParameters() {
        return new Object[]{this.getFormEnvironment(), this.isInputValid(), this.getTextComponent().getText()};
    }

    private boolean isInputValid() {
        JFormattedTextField textField = (JFormattedTextField)this.getTextComponent();
        JFormattedTextField.AbstractFormatter formatter = textField.getFormatter();
        if (formatter != null) {
            try {
                formatter.stringToValue(textField.getText());
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Object getValue() {
        return ((JFormattedTextField)this.getTextComponent()).getValue();
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JFormattedTextField.class;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JFormattedTextField textField = (JFormattedTextField)this.getTextComponent();
        String oldText = textField.getText();
        Object oldValue = textField.getValue();
        while (true) {
            textField.setText(oldText);
            textField.setValue(oldValue);
            String newValue = console.askString(this.getConsoleLabelText(false) + this.getFormatDescription(), oldText);
            textField.setText(newValue);
            try {
                textField.commitEdit();
            }
            catch (ParseException e) {
                continue;
            }
            InputVerifier inputVerifier = textField.getInputVerifier();
            try {
                if (inputVerifier == null) {
                    return true;
                }
                if (!inputVerifier.verify(textField)) continue;
                textField.commitEdit();
                return true;
            }
            catch (ParseException parseException) {
                continue;
            }
            break;
        }
    }

    protected String getFormatDescription() {
        return "";
    }

    private void updateFormatter(JFormattedTextField textField) {
        textField.setFormatterFactory(new DefaultFormatterFactory(this.createFormatter()));
    }
}

