/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.macos;

import com.install4j.runtime.installer.platform.macos.ServiceManagement;

public class MacServiceManagement {
    public static ServiceManagementResult registerMainBundleAsLoginItem() {
        return ServiceManagement.registerMain();
    }

    public static ServiceManagementResult unregisterMainBundleAsLoginItem() {
        return ServiceManagement.unregisterMain();
    }

    public static AppServiceStatus getMainBundleLoginItemStatus() {
        return ServiceManagement.getMainBundleStatus();
    }

    public static ServiceManagementResult registerLaunchAgent(String plistName) {
        return ServiceManagement.register(MacServiceManagement.checkPlistName(plistName), false);
    }

    public static ServiceManagementResult unregisterLaunchAgent(String plistName) {
        return ServiceManagement.unregister(MacServiceManagement.checkPlistName(plistName), false);
    }

    public static AppServiceStatus getLaunchAgentStatus(String plistName) {
        return ServiceManagement.getStatus(MacServiceManagement.checkPlistName(plistName), false);
    }

    public static ServiceManagementResult registerLaunchDaemon(String plistName) {
        return ServiceManagement.register(MacServiceManagement.checkPlistName(plistName), true);
    }

    public static ServiceManagementResult unregisterLaunchDaemon(String plistName) {
        return ServiceManagement.unregister(MacServiceManagement.checkPlistName(plistName), true);
    }

    public static AppServiceStatus getLaunchDaemonStatus(String plistName) {
        return ServiceManagement.getStatus(MacServiceManagement.checkPlistName(plistName), true);
    }

    public static boolean openSystemSettingsLoginItems() {
        return ServiceManagement.openSystemSettingsLoginItems();
    }

    private static String checkPlistName(String plistName) {
        if (plistName == null) {
            throw new IllegalArgumentException("plistName must not be null");
        }
        if (!plistName.endsWith(".plist")) {
            return plistName + ".plist";
        }
        return plistName;
    }

    public static enum AppServiceStatus {
        NOT_REGISTERED,
        ENABLED,
        REQUIRES_APPROVAL,
        NOT_FOUND;

    }

    public static enum ServiceManagementResult {
        OK,
        ERROR_UNSUPPORTED,
        ERROR_UNKNOWN,
        ERROR_REQUIRES_APPROVAL,
        ERROR_INTERNAL_FAILURE,
        ERROR_INVALID_SIGNATURE,
        ERROR_AUTHORIZATION_FAILURE,
        ERROR_TOOL_NOT_VALID,
        ERROR_JOB_NOT_FOUND,
        ERROR_SERVICE_UNAVAILABLE,
        ERROR_JOB_PLIST_NOT_FOUND,
        ERROR_JOB_MUST_BE_ENABLED,
        ERROR_INVALID_PLIST,
        ERROR_LAUNCH_DENIED_BY_USER,
        ERROR_ALREADY_REGISTERED;

    }
}

