/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.constants.ConstantReference;
import org.gjt.jclasslib.structures.constants.MethodHandleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bB\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0010\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0014J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020\rH\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010.\u001a\u00020\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001d\u00a8\u00060"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantMethodHandleInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "type", "Lorg/gjt/jclasslib/structures/constants/MethodHandleType;", "(Lorg/gjt/jclasslib/structures/constants/MethodHandleType;Lorg/gjt/jclasslib/structures/ClassFile;)V", "input", "Lorg/gjt/jclasslib/io/DataInput;", "(Lorg/gjt/jclasslib/structures/ClassFile;Lorg/gjt/jclasslib/io/DataInput;)V", "referenceIndex", "", "getReferenceIndex", "()I", "setReferenceIndex", "(I)V", "getType", "()Lorg/gjt/jclasslib/structures/constants/MethodHandleType;", "setType", "(Lorg/gjt/jclasslib/structures/constants/MethodHandleType;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "verbose", "", "getVerbose", "()Ljava/lang/String;", "name", "getName", "referenceConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantReference;", "getReferenceConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantReference;", "readData", "", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "equals", "", "other", "", "hashCode", "debugInfo", "getDebugInfo", "data"})
public final class ConstantMethodHandleInfo
extends AbstractConstant {
    private int referenceIndex;
    public MethodHandleType type;

    private ConstantMethodHandleInfo(ClassFile classFile) {
        super(classFile);
    }

    public ConstantMethodHandleInfo(@NotNull MethodHandleType type, @NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        this(classFile);
        this.setType(type);
    }

    public ConstantMethodHandleInfo(@NotNull ClassFile classFile, @NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(classFile);
        this.read(input);
    }

    public final int getReferenceIndex() {
        return this.referenceIndex;
    }

    public final void setReferenceIndex(int n) {
        this.referenceIndex = n;
    }

    @NotNull
    public final MethodHandleType getType() {
        MethodHandleType methodHandleType = this.type;
        if (methodHandleType != null) {
            return methodHandleType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        return null;
    }

    public final void setType(@NotNull MethodHandleType methodHandleType) {
        Intrinsics.checkNotNullParameter((Object)methodHandleType, (String)"<set-?>");
        this.type = methodHandleType;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.METHOD_HANDLE;
    }

    @Override
    @NotNull
    public String getVerbose() {
        return this.getName();
    }

    @NotNull
    public final String getName() {
        return this.getConstantType().getVerbose() + " " + this.getReferenceConstant().getVerbose();
    }

    @NotNull
    public final ConstantReference getReferenceConstant() {
        return (ConstantReference)this.getClassFile().getConstantPoolEntry(this.referenceIndex, Reflection.getOrCreateKotlinClass(ConstantReference.class));
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.setType((MethodHandleType)MethodHandleType.Companion.getFromTag(input.readUnsignedByte()));
        this.referenceIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.METHOD_HANDLE.getTag());
        output.writeByte(this.getType().getTag());
        output.writeShort(this.referenceIndex);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantMethodHandleInfo)) {
            return false;
        }
        return super.equals(other) && ((ConstantMethodHandleInfo)other).referenceIndex == this.referenceIndex && ((ConstantMethodHandleInfo)other).getType() == this.getType();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.referenceIndex;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with referenceIndex " + this.referenceIndex + " and type " + this.getType();
    }
}

