/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.pkcs11.jacknji11.CKR;
import org.pkcs11.jacknji11.NativeProvider;

public class NativeProviderMetrics {
    public static final String C_Initialize = "C_Initialize";
    public static final String C_Finalize = "C_Finalize";
    public static final String C_GetInfo = "C_GetInfo";
    public static final String C_GetSlotList = "C_GetSlotList";
    public static final String C_GetSlotInfo = "C_GetSlotInfo";
    public static final String C_GetTokenInfo = "C_GetTokenInfo";
    public static final String C_WaitForSlotEvent = "C_WaitForSlotEvent";
    public static final String C_GetMechanismList = "C_GetMechanismList";
    public static final String C_GetMechanismInfo = "C_GetMechanismInfo";
    public static final String C_InitToken = "C_InitToken";
    public static final String C_InitPIN = "C_InitPIN";
    public static final String C_SetPIN = "C_SetPIN";
    public static final String C_OpenSession = "C_OpenSession";
    public static final String C_CloseSession = "C_CloseSession";
    public static final String C_CloseAllSessions = "C_CloseAllSessions";
    public static final String C_GetSessionInfo = "C_GetSessionInfo";
    public static final String C_GetOperationState = "C_GetOperationState";
    public static final String C_SetOperationState = "C_SetOperationState";
    public static final String C_Login = "C_Login";
    public static final String C_Logout = "C_Logout";
    public static final String C_CreateObject = "C_CreateObject";
    public static final String C_CopyObject = "C_CopyObject";
    public static final String C_DestroyObject = "C_DestroyObject";
    public static final String C_GetObjectSize = "C_GetObjectSize";
    public static final String C_GetAttributeValue = "C_GetAttributeValue";
    public static final String C_SetAttributeValue = "C_SetAttributeValue";
    public static final String C_FindObjectsInit = "C_FindObjectsInit";
    public static final String C_FindObjects = "C_FindObjects";
    public static final String C_FindObjectsFinal = "C_FindObjectsFinal";
    public static final String C_EncryptInit = "C_EncryptInit";
    public static final String C_Encrypt = "C_Encrypt";
    public static final String C_EncryptUpdate = "C_EncryptUpdate";
    public static final String C_EncryptFinal = "C_EncryptFinal";
    public static final String C_DecryptInit = "C_DecryptInit";
    public static final String C_Decrypt = "C_Decrypt";
    public static final String C_DecryptUpdate = "C_DecryptUpdate";
    public static final String C_DecryptFinal = "C_DecryptFinal";
    public static final String C_DigestInit = "C_DigestInit";
    public static final String C_Digest = "C_Digest";
    public static final String C_DigestUpdate = "C_DigestUpdate";
    public static final String C_DigestKey = "C_DigestKey";
    public static final String C_DigestFinal = "C_DigestFinal";
    public static final String C_SignInit = "C_SignInit";
    public static final String C_Sign = "C_Sign";
    public static final String C_SignUpdate = "C_SignUpdate";
    public static final String C_SignFinal = "C_SignFinal";
    public static final String C_SignRecoverInit = "C_SignRecoverInit";
    public static final String C_SignRecover = "C_SignRecover";
    public static final String C_VerifyInit = "C_VerifyInit";
    public static final String C_Verify = "C_Verify";
    public static final String C_VerifyUpdate = "C_VerifyUpdate";
    public static final String C_VerifyFinal = "C_VerifyFinal";
    public static final String C_VerifyRecoverInit = "C_VerifyRecoverInit";
    public static final String C_VerifyRecover = "C_VerifyRecover";
    public static final String C_DigestEncryptUpdate = "C_DigestEncryptUpdate";
    public static final String C_DecryptDigestUpdate = "C_DecryptDigestUpdate";
    public static final String C_SignEncryptUpdate = "C_SignEncryptUpdate";
    public static final String C_DecryptVerifyUpdate = "C_DecryptVerifyUpdate";
    public static final String C_GenerateKey = "C_GenerateKey";
    public static final String C_GenerateKeyPair = "C_GenerateKeyPair";
    public static final String C_WrapKey = "C_WrapKey";
    public static final String C_UnwrapKey = "C_UnwrapKey";
    public static final String C_DeriveKey = "C_DeriveKey";
    public static final String C_SeedRandom = "C_SeedRandom";
    public static final String C_GenerateRandom = "C_GenerateRandom";
    public static final String C_GetFunctionStatus = "C_GetFunctionStatus";
    public static final String C_CancelFunction = "C_CancelFunction";
    private final Map<String, Entry> entries = new ConcurrentHashMap<String, Entry>();

    public void reset() {
        this.entries.clear();
    }

    void registerResult(String method, long rv, long ms) {
        this.getEntry(method).result(rv, ms);
    }

    void registerAttempt(String method) {
        this.getEntry(method).incAttempts();
    }

    private Entry getEntry(String name) {
        return this.entries.computeIfAbsent(name, k -> new Entry());
    }

    public int getAttempts(String method) {
        return this.getEntry(method).getAttempts();
    }

    public int getAttempts(String method, long rv) {
        return this.getEntry(method).getAttempts(rv);
    }

    public long getDuration(String method) {
        return this.getEntry(method).getDuration();
    }

    public long getDuration(String method, long rv) {
        return this.getEntry(method).duration(rv).get();
    }

    public int getExceptions(String key, Class<?> exceptionClass) {
        return this.getEntry(key).getExceptions(exceptionClass);
    }

    NativeProvider intercept(NativeProvider nativeProvider) {
        return (NativeProvider)Proxy.newProxyInstance(nativeProvider.getClass().getClassLoader(), new Class[]{NativeProvider.class}, (proxy, method, args) -> this.handleMethod(nativeProvider, method, args));
    }

    private Object handleMethod(NativeProvider nativeProvider, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (method.getDeclaringClass() == NativeProvider.class && method.getName().startsWith("C_")) {
            return this.handleCryptokiMethod(nativeProvider, method, args);
        }
        return method.invoke((Object)nativeProvider, args);
    }

    private long handleCryptokiMethod(NativeProvider nativeProvider, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        String name = method.getName();
        try {
            this.registerAttempt(name);
            long s = System.currentTimeMillis();
            long rv = (Long)method.invoke((Object)nativeProvider, args);
            long e = System.currentTimeMillis();
            this.registerResult(name, rv, e - s);
            return rv;
        }
        catch (RuntimeException exc) {
            this.incError(name, exc.getClass());
            throw exc;
        }
    }

    private void incError(String method, Class<?> exceptionClass) {
        this.getEntry(method).incError(exceptionClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
            sb.append(entry.getKey()).append(":\n");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static class Entry {
        AtomicInteger attempts = new AtomicInteger(0);
        AtomicLong duration = new AtomicLong(0L);
        Map<Long, AtomicInteger> attemptsPerResult = Collections.synchronizedMap(new HashMap());
        Map<Long, AtomicLong> durationPerResult = Collections.synchronizedMap(new HashMap());
        Map<Class<?>, AtomicInteger> exceptions = Collections.synchronizedMap(new HashMap());

        Entry() {
        }

        private void incDuration(long rv, long ms) {
            this.duration(rv).addAndGet(ms);
        }

        private AtomicLong duration(long rv) {
            return this.durationPerResult.computeIfAbsent(rv, k -> new AtomicLong(0L));
        }

        private void incAttempts(long rv) {
            this.attempts(rv).incrementAndGet();
        }

        private AtomicInteger attempts(long rv) {
            return this.attemptsPerResult.computeIfAbsent(rv, k -> new AtomicInteger(0));
        }

        void incError(Class<?> exceptionClass) {
            this.exceptionCounter(exceptionClass).incrementAndGet();
        }

        private AtomicInteger exceptionCounter(Class<?> exceptionClass) {
            return this.exceptions.computeIfAbsent(exceptionClass, k -> new AtomicInteger(0));
        }

        int getAttempts() {
            return this.attempts.get();
        }

        long getDuration() {
            return this.duration.get();
        }

        int getAttempts(long rv) {
            return this.attempts(rv).get();
        }

        int getExceptions(Class<?> exceptionClass) {
            return this.exceptionCounter(exceptionClass).get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("  Attempts: ").append(this.attempts.get()).append("\n");
            sb.append("  Duration: ").append(this.formatDuration(this.duration.get(), this.attempts.get())).append("\n");
            for (Map.Entry<Long, AtomicInteger> entry : this.attemptsPerResult.entrySet()) {
                int attempts = entry.getValue().intValue();
                long duration = this.duration(entry.getKey()).get();
                sb.append("  ");
                sb.append(CKR.L2S(entry.getKey()));
                sb.append(" -> ");
                sb.append(attempts);
                sb.append(" (");
                sb.append(this.formatDuration(duration, attempts));
                sb.append(")");
                sb.append("\n");
            }
            for (Map.Entry<Constable, AtomicInteger> entry : this.exceptions.entrySet()) {
                sb.append("Exception: ").append(entry.getKey()).append(" -> ").append(entry.getValue()).append("\n");
            }
            return sb.toString();
        }

        private String formatDuration(long duration, long attempts) {
            return String.format("total: %dms avg: %4.2fms", duration, (double)duration * 1.0 / (double)attempts);
        }

        void result(long rv, long ms) {
            this.duration.addAndGet(ms);
            this.incAttempts(rv);
            this.incDuration(rv, ms);
        }

        void incAttempts() {
            this.attempts.incrementAndGet();
        }
    }
}

