/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pkcs11.jacknji11.Buf;
import org.pkcs11.jacknji11.C;
import org.pkcs11.jacknji11.CKC;
import org.pkcs11.jacknji11.CKK;
import org.pkcs11.jacknji11.CKO;
import org.pkcs11.jacknji11.Hex;
import org.pkcs11.jacknji11.UBigInt;
import org.pkcs11.jacknji11.ULong;

public class CKA {
    private static final Log log = LogFactory.getLog(CKA.class);
    public static final long CKF_ARRAY_ATTRIBUTE = 0x40000000L;
    public static final long CLASS = 0L;
    public static final long TOKEN = 1L;
    public static final long PRIVATE = 2L;
    public static final long LABEL = 3L;
    public static final long APPLICATION = 16L;
    public static final long VALUE = 17L;
    public static final long OBJECT_ID = 18L;
    public static final long CERTIFICATE_TYPE = 128L;
    public static final long ISSUER = 129L;
    public static final long SERIAL_NUMBER = 130L;
    public static final long AC_ISSUER = 131L;
    public static final long OWNER = 132L;
    public static final long ATTR_TYPES = 133L;
    public static final long TRUSTED = 134L;
    public static final long CERTIFICATE_CATEGORY = 135L;
    public static final long JAVA_MIDP_SECURITY_DOMAIN = 136L;
    public static final long URL = 137L;
    public static final long HASH_OF_SUBJECT_PUBLIC_KEY = 138L;
    public static final long HASH_OF_ISSUER_PUBLIC_KEY = 139L;
    public static final long CHECK_VALUE = 144L;
    public static final long KEY_TYPE = 256L;
    public static final long SUBJECT = 257L;
    public static final long ID = 258L;
    public static final long SENSITIVE = 259L;
    public static final long ENCRYPT = 260L;
    public static final long DECRYPT = 261L;
    public static final long WRAP = 262L;
    public static final long UNWRAP = 263L;
    public static final long SIGN = 264L;
    public static final long SIGN_RECOVER = 265L;
    public static final long VERIFY = 266L;
    public static final long VERIFY_RECOVER = 267L;
    public static final long DERIVE = 268L;
    public static final long START_DATE = 272L;
    public static final long END_DATE = 273L;
    public static final long MODULUS = 288L;
    public static final long MODULUS_BITS = 289L;
    public static final long PUBLIC_EXPONENT = 290L;
    public static final long PRIVATE_EXPONENT = 291L;
    public static final long PRIME_1 = 292L;
    public static final long PRIME_2 = 293L;
    public static final long EXPONENT_1 = 294L;
    public static final long EXPONENT_2 = 295L;
    public static final long COEFFICIENT = 296L;
    public static final long PRIME = 304L;
    public static final long SUBPRIME = 305L;
    public static final long BASE = 306L;
    public static final long PRIME_BITS = 307L;
    public static final long SUBPRIME_BITS = 308L;
    public static final long VALUE_BITS = 352L;
    public static final long VALUE_LEN = 353L;
    public static final long EXTRACTABLE = 354L;
    public static final long LOCAL = 355L;
    public static final long NEVER_EXTRACTABLE = 356L;
    public static final long ALWAYS_SENSITIVE = 357L;
    public static final long MODIFIABLE = 368L;
    public static final long EC_PARAMS = 384L;
    public static final long EC_POINT = 385L;
    public static final long SECONDARY_AUTH = 512L;
    public static final long AUTH_PIN_FLAGS = 513L;
    public static final long ALWAYS_AUTHENTICATE = 514L;
    public static final long WRAP_WITH_TRUSTED = 528L;
    public static final long WRAP_TEMPLATE = 1073742353L;
    public static final long UNWRAP_TEMPLATE = 1073742354L;
    public static final long OTP_FORMAT = 544L;
    public static final long OTP_LENGTH = 545L;
    public static final long OTP_TIME_INTERVAL = 546L;
    public static final long OTP_USER_FRIENDLY_MODE = 547L;
    public static final long OTP_CHALLENGE_REQUIREMENT = 548L;
    public static final long OTP_TIME_REQUIREMENT = 549L;
    public static final long OTP_COUNTER_REQUIREMENT = 550L;
    public static final long OTP_PIN_REQUIREMENT = 551L;
    public static final long OTP_COUNTER = 558L;
    public static final long OTP_TIME = 559L;
    public static final long OTP_USER_IDENTIFIER = 554L;
    public static final long OTP_SERVICE_IDENTIFIER = 555L;
    public static final long OTP_SERVICE_LOGO = 556L;
    public static final long OTP_SERVICE_LOGO_TYPE = 557L;
    public static final long HW_FEATURE_TYPE = 768L;
    public static final long RESET_ON_INIT = 769L;
    public static final long HAS_RESET = 770L;
    public static final long PIXEL_X = 1024L;
    public static final long PIXEL_Y = 1025L;
    public static final long RESOLUTION = 1026L;
    public static final long CHAR_ROWS = 1027L;
    public static final long CHAR_COLUMNS = 1028L;
    public static final long COLOR = 1029L;
    public static final long BITS_PER_PIXEL = 1030L;
    public static final long CHAR_SETS = 1152L;
    public static final long ENCODING_METHODS = 1153L;
    public static final long MIME_TYPES = 1154L;
    public static final long MECHANISM_TYPE = 1280L;
    public static final long REQUIRED_CMS_ATTRIBUTES = 1281L;
    public static final long DEFAULT_CMS_ATTRIBUTES = 1282L;
    public static final long SUPPORTED_CMS_ATTRIBUTES = 1283L;
    public static final long ALLOWED_MECHANISMS = 0x40000600L;
    public static final long VENDOR_PTK_USAGE_COUNT = -2147483391L;
    public static final long VENDOR_PTK_TIME_STAMP = -2147483390L;
    public static final long VENDOR_PTK_CHECK_VALUE = -2147483389L;
    public static final long VENDOR_PTK_MECHANISM_LIST = -2147483388L;
    public static final long VENDOR_PTK_SIGN_LOCAL_CERT = -2147483353L;
    public static final long VENDOR_PTK_EXPORT = -2147483352L;
    public static final long VENDOR_PTK_EXPORTABLE = -2147483351L;
    public static final long VENDOR_PTK_DELETABLE = -2147483350L;
    public static final long VENDOR_PTK_IMPORT = -2147483349L;
    public static final long VENDOR_PTK_KEY_SIZE = -2147483348L;
    public static final long VENDOR_PTK_ISSUER_STR = -2147483344L;
    public static final long VENDOR_PTK_SUBJECT_STR = -2147483343L;
    public static final long VENDOR_PTK_SERIAL_NUMBER_INT = -2147483342L;
    public static final long VENDOR_PTK_RECORD_COUNT = -2147483338L;
    public static final long VENDOR_PTK_RECORD_NUMBER = -2147483337L;
    public static final long VENDOR_PTK_PURGE = -2147483335L;
    public static final long VENDOR_PTK_EVENT_LOG_FULL = -2147483334L;
    public static final long VENDOR_PTK_SECURITY_MODE = -2147483328L;
    public static final long VENDOR_PTK_TRANSPORT_MODE = -2147483327L;
    public static final long VENDOR_PTK_BATCH = -2147483326L;
    public static final long VENDOR_PTK_HW_STATUS = -2147483325L;
    public static final long VENDOR_PTK_FREE_MEM = -2147483324L;
    public static final long VENDOR_PTK_TAMPER_CMD = -2147483323L;
    public static final long VENDOR_PTK_DATE_OF_MANUFACTURE = -2147483322L;
    public static final long VENDOR_PTK_HALT_CMD = -2147483321L;
    public static final long VENDOR_PTK_APPLICATION_COUNT = -2147483320L;
    public static final long VENDOR_PTK_FW_VERSION = -2147483319L;
    public static final long VENDOR_PTK_RESCAN_PERIPHERALS_CMD = -2147483318L;
    public static final long VENDOR_PTK_RTC_AAC_ENABLED = -2147483317L;
    public static final long VENDOR_PTK_RTC_AAC_GUARD_SECONDS = -2147483316L;
    public static final long VENDOR_PTK_RTC_AAC_GUARD_COUNT = -2147483315L;
    public static final long VENDOR_PTK_RTC_AAC_GUARD_DURATION = -2147483314L;
    public static final long VENDOR_PTK_HW_EXT_INFO_STR = -2147483313L;
    public static final long VENDOR_PTK_SLOT_ID = -2147483311L;
    public static final long VENDOR_PTK_MAX_SESSIONS = -2147483307L;
    public static final long VENDOR_PTK_MIN_PIN_LEN = -2147483306L;
    public static final long VENDOR_PTK_MAX_PIN_FAIL = -2147483304L;
    public static final long VENDOR_PTK_FLAGS = -2147483303L;
    public static final long VENDOR_PTK_VERIFY_OS = -2147483280L;
    public static final long VENDOR_PTK_VERSION = -2147483263L;
    public static final long VENDOR_PTK_MANUFACTURER = -2147483262L;
    public static final long VENDOR_PTK_BUILD_DATE = -2147483261L;
    public static final long VENDOR_PTK_FINGERPRINT = -2147483260L;
    public static final long VENDOR_PTK_ROM_SPACE = -2147483259L;
    public static final long VENDOR_PTK_RAM_SPACE = -2147483258L;
    public static final long VENDOR_PTK_FM_STATUS = -2147483257L;
    public static final long VENDOR_PTK_DELETE_FM = -2147483256L;
    public static final long VENDOR_PTK_FM_STARTUP_STATUS = -2147483255L;
    public static final long VENDOR_PTK_CERTIFICATE_START_TIME = -2147483248L;
    public static final long VENDOR_PTK_CERTIFICATE_END_TIME = -2147483247L;
    public static final long VENDOR_PTK_PKI_ATTRIBUTE_BER_ENCODED = -2147483088L;
    public static final long VENDOR_PTK_HIFACE_MASTER = -2147483056L;
    public static final long VENDOR_PTK_CKA_SEED = -2147483040L;
    public static final long VENDOR_PTK_CKA_COUNTER = -2147483039L;
    public static final long VENDOR_PTK_CKA_H_VALUE = -2147483038L;
    public static final long VENDOR_PTK_ENUM_ATTRIBUTE = 65535L;
    private static final Map<Long, String> L2S = C.createL2SMap(CKA.class);
    public long type;
    public byte[] pValue;
    public long ulValueLen;
    private boolean isSet;

    public static final String L2S(long cka) {
        return C.l2s(L2S, CKA.class.getSimpleName(), cka);
    }

    private CKA(long type) {
        this.type = type;
    }

    public CKA(long type, Object value) {
        this.type = type;
        if (value == null) {
            this.pValue = null;
            this.ulValueLen = 0L;
        } else if (value instanceof Boolean) {
            this.pValue = new byte[]{(Boolean)value != false ? (byte)1 : 0};
            this.ulValueLen = 1L;
        } else if (value instanceof byte[]) {
            this.pValue = (byte[])value;
            this.ulValueLen = this.pValue.length;
        } else if (value instanceof BigInteger) {
            this.pValue = UBigInt.ubigint2b((BigInteger)value);
            this.ulValueLen = this.pValue.length;
        } else if (value instanceof Number) {
            this.pValue = ULong.ulong2b(((Number)value).longValue());
            this.ulValueLen = this.pValue.length;
        } else if (value instanceof String) {
            this.pValue = ((String)value).getBytes();
            this.ulValueLen = this.pValue.length;
        } else {
            throw new RuntimeException("Unknown att type: " + String.valueOf(value.getClass()));
        }
        this.isSet = true;
    }

    public static CKA allocate(long type, int size) {
        CKA cka = new CKA(type);
        cka.pValue = size > 0 ? new byte[size] : null;
        cka.ulValueLen = size;
        return cka;
    }

    public static CKA indefinite(long type) {
        return CKA.allocate(type, 0);
    }

    public boolean hasValue() {
        return this.isSet && this.ulValueLen > 0L && this.pValue != null && (long)this.pValue.length >= this.ulValueLen;
    }

    public boolean isInvalid() {
        return this.ulValueLen == -1L;
    }

    public boolean isEmpty() {
        return this.isSet && this.ulValueLen == 0L;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void set() {
        this.isSet = true;
    }

    private byte[] getValueInternal() {
        return this.hasValue() ? Buf.substring(this.pValue, 0, (int)this.ulValueLen) : null;
    }

    public byte[] getValue() {
        return this.getValueInternal();
    }

    public String getValueStr() {
        return this.hasValue() ? new String(this.getValueInternal()) : null;
    }

    public Long getValueLong() {
        if (!this.hasValue()) {
            return null;
        }
        if (this.ulValueLen != (long)ULong.ULONG_SIZE.size()) {
            throw new IllegalStateException(String.format("Method getValueLong called when value is not long type of length %d.  Got length: %d, CKA type: 0x%08x(%s), value: %s", ULong.ULONG_SIZE.size(), this.ulValueLen, this.type, L2S.get(this.type), Hex.b2s(this.getValue())));
        }
        return ULong.b2ulong(this.getValue());
    }

    public Boolean getValueBool() {
        if (!this.hasValue()) {
            return null;
        }
        if (this.ulValueLen != 1L) {
            throw new IllegalStateException(String.format("Method getValueBool called when value is not boolean type of length 1.  Got length: %d, CKA type: 0x%08x(%s), value: %s", this.ulValueLen, this.type, L2S.get(this.type), Hex.b2s(this.getValue())));
        }
        return this.pValue[0] != 0;
    }

    public BigInteger getValueBigInt() {
        return this.hasValue() ? UBigInt.b2ubigint(this.getValueInternal()) : null;
    }

    public void dump(StringBuilder sb) {
        sb.append(String.format("type=0x%08x{%s} ", this.type, CKA.L2S(this.type)));
        this.dumpState(sb);
        if (this.hasValue()) {
            this.dumpValue(sb);
        }
    }

    private void dumpValue(StringBuilder sb) {
        try {
            switch ((int)this.type) {
                case 0: {
                    Long cko = this.getValueLong();
                    sb.append(String.format(" value=0x%08x{%s}", cko != null ? cko : -1L, cko != null ? CKO.L2S(cko) : "null"));
                    return;
                }
                case -2147483353: 
                case -2147483352: 
                case -2147483351: 
                case -2147483350: 
                case -2147483349: 
                case -2147483334: 
                case -2147483280: 
                case 1: 
                case 2: 
                case 134: 
                case 259: 
                case 260: 
                case 261: 
                case 262: 
                case 263: 
                case 264: 
                case 265: 
                case 266: 
                case 267: 
                case 268: 
                case 354: 
                case 355: 
                case 356: 
                case 357: 
                case 368: 
                case 514: 
                case 528: 
                case 769: 
                case 770: {
                    Boolean b = this.getValueBool();
                    sb.append(" value=").append(b != null ? (b.booleanValue() ? "TRUE" : "FALSE") : "null");
                    return;
                }
                case -2147483390: 
                case -2147483344: 
                case -2147483343: 
                case -2147483322: 
                case -2147483317: 
                case -2147483313: 
                case -2147483262: 
                case -2147483261: 
                case -2147483248: 
                case -2147483247: 
                case 3: 
                case 16: 
                case 137: 
                case 272: 
                case 273: {
                    sb.append(" value=").append(Buf.escstr(this.getValue()));
                    return;
                }
                case 128: {
                    Long ckc = this.getValueLong();
                    sb.append(String.format(" value=0x%08x{%s}", ckc != null ? ckc : -1L, ckc != null ? CKC.L2S(ckc) : "null"));
                    return;
                }
                case 256: {
                    Long ckk = this.getValueLong();
                    sb.append(String.format(" value=0x%08x{%s}", ckk != null ? ckk : -1L, ckk != null ? CKK.L2S(ckk) : "null"));
                    return;
                }
                case -2147483391: 
                case -2147483348: 
                case -2147483338: 
                case -2147483337: 
                case -2147483324: 
                case -2147483320: 
                case -2147483316: 
                case -2147483315: 
                case -2147483314: 
                case -2147483311: 
                case -2147483307: 
                case -2147483306: 
                case -2147483304: 
                case -2147483259: 
                case -2147483258: 
                case -2147483039: 
                case 289: 
                case 307: 
                case 308: 
                case 352: 
                case 353: 
                case 545: 
                case 546: 
                case 1024: 
                case 1025: 
                case 1026: 
                case 1027: 
                case 1028: 
                case 1030: {
                    sb.append(" value=").append(this.getValueLong());
                    return;
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected CKA values", (Throwable)e);
        }
        byte[] value = this.getValue();
        sb.append('\n');
        Hex.dump(sb, value, 0, (int)this.ulValueLen, "    ", 32, false);
    }

    private void dumpState(StringBuilder sb) {
        if (this.isSet) {
            if (this.ulValueLen == 0L) {
                sb.append(" EMPTY");
            } else if (this.ulValueLen == -1L) {
                sb.append(" INVALID");
            } else {
                if (this.pValue == null) {
                    sb.append(" DEFINITE");
                }
                sb.append(String.format(" [%dB]", this.ulValueLen));
            }
        } else if (this.ulValueLen == 0L) {
            sb.append(" INDEFINITE");
        } else if (this.ulValueLen == -1L) {
            sb.append(" INVALID");
        } else {
            if (this.pValue != null) {
                sb.append(" ALLOCATED");
            }
            sb.append(String.format(" [%dB]", this.ulValueLen));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.type ^ this.type >>> 32);
        result = 31 * result + (int)(this.ulValueLen ^ this.ulValueLen >>> 32);
        result = 31 * result + (this.isSet ? 1231 : 1237);
        if (this.isSet) {
            result = 31 * result + Arrays.hashCode(this.getValueInternal());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CKA other = (CKA)obj;
        if (this.ulValueLen != other.ulValueLen) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.isSet != other.isSet) {
            return false;
        }
        return !this.isSet || Arrays.equals(this.getValueInternal(), other.getValueInternal());
    }
}

